/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.sign;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.mojo.webstart.sign.KeystoreConfig;
import org.codehaus.mojo.webstart.sign.SignTool;

public class SignConfig {
    private File workDirectory;
    private boolean verbose;
    private KeystoreConfig keystoreConfig;
    private String keystore;
    private File workingKeystore;
    private String keyalg;
    private String keysize;
    private String sigalg;
    private String sigfile;
    private String storetype;
    private String storepass;
    private String keypass;
    private String validity;
    private String dnameCn;
    private String dnameOu;
    private String dnameL;
    private String dnameSt;
    private String dnameO;
    private String dnameC;
    private String alias;
    private boolean verify;
    private String maxMemory;

    public void init(File workDirectory, boolean verbose, SignTool signTool, ClassLoader classLoader) throws MojoExecutionException {
        File keystoreFile;
        this.workDirectory = workDirectory;
        this.setVerbose(verbose);
        if (this.workingKeystore == null) {
            this.workingKeystore = new File(workDirectory, "workingKeystore");
        }
        if (this.keystoreConfig != null && this.keystoreConfig.isGen()) {
            keystoreFile = new File(this.getKeystore());
            if (this.keystoreConfig.isDelete()) {
                signTool.deleteKeyStore(keystoreFile, this.isVerbose());
            }
            signTool.generateKey(this, keystoreFile);
        } else {
            keystoreFile = signTool.getKeyStoreFile(this.getKeystore(), this.workingKeystore, classLoader);
            this.setKeystore(keystoreFile.getAbsolutePath());
        }
        keystoreFile = new File(this.getKeystore());
        if (!keystoreFile.exists()) {
            throw new MojoExecutionException("Could not obtain key store location at " + this.keystore);
        }
    }

    public JarSignerRequest createSignRequest(File jarToSign, File signedJar) {
        JarSignerSignRequest request = new JarSignerSignRequest();
        request.setAlias(this.getAlias());
        request.setKeypass(this.getKeypass());
        request.setKeystore(this.getKeystore());
        request.setSigfile(this.getSigfile());
        request.setStorepass(this.getStorepass());
        request.setStoretype(this.getStoretype());
        request.setWorkingDirectory(this.workDirectory);
        request.setMaxMemory(this.getMaxMemory());
        request.setVerbose(this.isVerbose());
        request.setArchive(jarToSign);
        request.setSignedjar(signedJar);
        return request;
    }

    public JarSignerVerifyRequest createVerifyRequest(File jarFile, boolean certs) {
        JarSignerVerifyRequest request = new JarSignerVerifyRequest();
        request.setCerts(certs);
        request.setWorkingDirectory(this.workDirectory);
        request.setMaxMemory(this.getMaxMemory());
        request.setVerbose(this.isVerbose());
        request.setArchive(jarFile);
        return request;
    }

    public KeyToolGenerateKeyPairRequest createKeyGenRequest(File keystoreFile) {
        KeyToolGenerateKeyPairRequest request = new KeyToolGenerateKeyPairRequest();
        request.setAlias(this.getAlias());
        request.setDname(this.getDname());
        request.setKeyalg(this.getKeyalg());
        request.setKeypass(this.getKeypass());
        request.setKeysize(this.getKeysize());
        request.setKeystore(this.getKeystore());
        request.setSigalg(this.getSigalg());
        request.setStorepass(this.getStorepass());
        request.setStoretype(this.getStoretype());
        request.setValidity(this.getValidity());
        request.setVerbose(this.isVerbose());
        request.setWorkingDirectory(this.workDirectory);
        return request;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void setKeystoreConfig(KeystoreConfig keystoreConfig) {
        this.keystoreConfig = keystoreConfig;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setWorkingKeystore(File workingKeystore) {
        this.workingKeystore = workingKeystore;
    }

    public void setKeyalg(String keyalg) {
        this.keyalg = keyalg;
    }

    public void setKeysize(String keysize) {
        this.keysize = keysize;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public void setSigfile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public void setDnameCn(String dnameCn) {
        this.dnameCn = dnameCn;
    }

    public void setDnameOu(String dnameOu) {
        this.dnameOu = dnameOu;
    }

    public void setDnameL(String dnameL) {
        this.dnameL = dnameL;
    }

    public void setDnameSt(String dnameSt) {
        this.dnameSt = dnameSt;
    }

    public void setDnameO(String dnameO) {
        this.dnameO = dnameO;
    }

    public void setDnameC(String dnameC) {
        this.dnameC = dnameC;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeyalg() {
        return this.keyalg;
    }

    public String getKeysize() {
        return this.keysize;
    }

    public String getSigalg() {
        return this.sigalg;
    }

    public String getSigfile() {
        return this.sigfile;
    }

    public String getStoretype() {
        return this.storetype;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public String getKeypass() {
        return this.keypass;
    }

    public String getValidity() {
        return this.validity;
    }

    public String getDnameCn() {
        return this.dnameCn;
    }

    public String getDnameOu() {
        return this.dnameOu;
    }

    public String getDnameL() {
        return this.dnameL;
    }

    public String getDnameSt() {
        return this.dnameSt;
    }

    public String getDnameO() {
        return this.dnameO;
    }

    public String getDnameC() {
        return this.dnameC;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean getVerify() {
        return this.verify;
    }

    public String getMaxMemory() {
        return this.maxMemory;
    }

    public String getDname() {
        StringBuffer buffer = new StringBuffer(128);
        this.appendToDnameBuffer(this.dnameCn, buffer, "CN");
        this.appendToDnameBuffer(this.dnameOu, buffer, "OU");
        this.appendToDnameBuffer(this.dnameL, buffer, "L");
        this.appendToDnameBuffer(this.dnameSt, buffer, "ST");
        this.appendToDnameBuffer(this.dnameO, buffer, "O");
        this.appendToDnameBuffer(this.dnameC, buffer, "C");
        return buffer.toString();
    }

    private void appendToDnameBuffer(String property, StringBuffer buffer, String prefix) {
        if (property != null) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(prefix).append("=");
            buffer.append(property.replaceAll(",", "\\\\,"));
        }
    }
}

