/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.sign;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerResult;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolException;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.KeyToolResult;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.mojo.webstart.sign.SignConfig;
import org.codehaus.mojo.webstart.sign.SignTool;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.cli.CommandLineException;

public class DefaultSignTool
extends AbstractLogEnabled
implements SignTool {
    private JarSigner jarSigner;
    private KeyTool keyTool;
    protected IOUtil ioUtil;

    public void generateKey(SignConfig config, File keystoreFile) throws MojoExecutionException {
        KeyToolGenerateKeyPairRequest request = config.createKeyGenRequest(keystoreFile);
        try {
            KeyToolResult result = this.keyTool.execute((KeyToolRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not sign jar " + keystoreFile, (Exception)exception);
            }
        }
        catch (KeyToolException e) {
            throw new MojoExecutionException("Could not find keytool", (Exception)((Object)e));
        }
    }

    public void sign(SignConfig config, File jarFile, File signedJar) throws MojoExecutionException {
        JarSignerRequest request = config.createSignRequest(jarFile, signedJar);
        try {
            JarSignerResult result = this.jarSigner.execute(request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not sign jar " + jarFile, (Exception)exception);
            }
        }
        catch (JarSignerException e) {
            throw new MojoExecutionException("Could not find jarSigner", (Exception)((Object)e));
        }
    }

    public void verify(SignConfig config, File jarFile, boolean certs) throws MojoExecutionException {
        JarSignerVerifyRequest request = config.createVerifyRequest(jarFile, certs);
        try {
            JarSignerResult result = this.jarSigner.execute((JarSignerRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not verify jar " + jarFile, (Exception)exception);
            }
        }
        catch (JarSignerException e) {
            throw new MojoExecutionException("Could not find jarSigner", (Exception)((Object)e));
        }
    }

    public boolean isJarSigned(File jarFile) throws MojoExecutionException {
        try {
            return DefaultSignTool.isArchiveSigned(jarFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not verifiy that jar is signed or not", (Exception)e);
        }
    }

    public void unsign(File jarFile, boolean verbose) throws MojoExecutionException {
        if (this.isJarSigned(jarFile)) {
            this.verboseLog(verbose, "Unsign jar " + jarFile);
            try {
                JarSignerUtil.unsignArchive((File)jarFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not find unsign jar " + jarFile, (Exception)e);
            }
        } else {
            this.verboseLog(verbose, "Jar " + jarFile + " is not signed.");
        }
    }

    public void deleteKeyStore(File keystore, boolean verbose) {
        if (keystore.exists()) {
            if (keystore.delete()) {
                this.infoOrDebug(verbose, "deleted keystore from: " + keystore.getAbsolutePath());
            } else {
                this.getLogger().warn("Couldn't delete keystore from: " + keystore.getAbsolutePath());
            }
        } else {
            this.infoOrDebug(verbose, "Skipping deletion of non existing keystore: " + keystore.getAbsolutePath());
        }
    }

    public File getKeyStoreFile(String keystore, File workingKeystore, ClassLoader classLoader) throws MojoExecutionException {
        File result;
        URI keystoreURI = null;
        try {
            keystoreURI = URI.create(keystore);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (keystoreURI == null || keystoreURI.getScheme() == null) {
            result = new File(keystore);
        } else {
            result = workingKeystore;
            this.ioUtil.makeDirectoryIfNecessary(result.getParentFile());
            this.ioUtil.copyResources(keystoreURI, classLoader, result);
        }
        return result;
    }

    protected void verboseLog(boolean verbose, String msg) {
        this.infoOrDebug(verbose || this.getLogger().isInfoEnabled(), msg);
    }

    private void infoOrDebug(boolean info, String msg) {
        if (info) {
            this.getLogger().info(msg);
        } else {
            this.getLogger().debug(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchiveSigned(File jarFile) throws IOException {
        if (jarFile == null) {
            throw new NullPointerException("jarFile");
        }
        ZipInputStream in = null;
        boolean suppressExceptionOnClose = true;
        try {
            boolean signed = false;
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
            ZipEntry ze = in.getNextEntry();
            while (ze != null) {
                if (DefaultSignTool.isSignatureFile(ze.getName())) {
                    signed = true;
                    break;
                }
                ze = in.getNextEntry();
            }
            suppressExceptionOnClose = false;
            boolean bl = signed;
            return bl;
        }
        finally {
            block11: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) break block11;
                    throw e;
                }
            }
        }
    }

    private static boolean isSignatureFile(String entryName) {
        if (entryName.regionMatches(true, 0, "META-INF", 0, 8) && (entryName = entryName.replace('\\', '/')).indexOf(47) == 8 && entryName.lastIndexOf(47) == 8) {
            if (entryName.regionMatches(true, entryName.length() - 3, ".SF", 0, 3)) {
                return true;
            }
            if (entryName.regionMatches(true, entryName.length() - 4, ".DSA", 0, 4)) {
                return true;
            }
            if (entryName.regionMatches(true, entryName.length() - 4, ".RSA", 0, 4)) {
                return true;
            }
            if (entryName.regionMatches(true, entryName.length() - 3, ".EC", 0, 3)) {
                return true;
            }
        }
        return false;
    }
}

