/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.webstart.JarResource;

public class ResolvedJarResource {
    private final JarResource jarResource;
    private final Artifact artifact;
    private String hrefValue;

    public ResolvedJarResource(Artifact artifact) {
        this(new JarResource(), artifact);
    }

    public ResolvedJarResource(JarResource jarResource, Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact must not be null");
        }
        if (jarResource == null) {
            throw new IllegalArgumentException("jarResource must not be null");
        }
        this.jarResource = jarResource;
        this.artifact = artifact;
        this.setHrefValue(jarResource.getHrefValue());
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getVersion() {
        return this.artifact.getVersion();
    }

    public String getMainClass() {
        return this.jarResource.getMainClass();
    }

    public boolean isOutputJarVersion() {
        return this.jarResource.isOutputJarVersion();
    }

    public boolean isIncludeInJnlp() {
        return this.jarResource.isIncludeInJnlp();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getHrefValue() {
        String result = this.hrefValue == null && this.getArtifact() != null ? this.getArtifact().getFile().getName() : this.hrefValue;
        return result;
    }

    public void setHrefValue(String hrefValue) {
        this.hrefValue = hrefValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResolvedJarResource)) {
            return false;
        }
        ResolvedJarResource other = (ResolvedJarResource)obj;
        if (this.fieldsAreNotEqual(this.getGroupId(), other.getGroupId())) {
            return false;
        }
        if (this.fieldsAreNotEqual(this.getArtifactId(), other.getArtifactId())) {
            return false;
        }
        if (this.fieldsAreNotEqual(this.getVersion(), other.getVersion())) {
            return false;
        }
        if (this.fieldsAreNotEqual(this.getType(), other.getType())) {
            return false;
        }
        return !this.fieldsAreNotEqual(this.getClassifier(), other.getClassifier());
    }

    private boolean fieldsAreNotEqual(Object field1, Object field2) {
        if (field1 == null) {
            return field2 != null;
        }
        return !field1.equals(field2);
    }

    public int hashCode() {
        int offset = 17;
        int multiplier = 37;
        int result = 17;
        result += 37 * this.fieldHashCode(this.getGroupId());
        result += 37 * this.fieldHashCode(this.getArtifactId());
        result += 37 * this.fieldHashCode(this.getVersion());
        result += 37 * this.fieldHashCode(this.getType());
        return result += 37 * this.fieldHashCode(this.getClassifier());
    }

    private int fieldHashCode(Object field) {
        return field == null ? 0 : field.hashCode();
    }
}

