/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.sign;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerResult;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolException;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.KeyToolResult;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.mojo.webstart.sign.SignConfig;
import org.codehaus.mojo.webstart.sign.SignTool;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DefaultSignTool
extends AbstractLogEnabled
implements SignTool {
    private static final String[] EXT_ARRAY = new String[]{"DSA", "RSA", "SF"};
    private JarSigner jarSigner;
    private KeyTool keyTool;
    private ArchiverManager archiverManager;
    private FileFilter removeSignatureFileFilter = new FileFilter(){
        private final List extToRemove = Arrays.asList(DefaultSignTool.access$000());

        public boolean accept(File file) {
            String extension = FileUtils.getExtension((String)file.getAbsolutePath());
            return this.extToRemove.contains(extension);
        }
    };

    public void generateKey(SignConfig config, File keystoreFile) throws MojoExecutionException {
        KeyToolGenerateKeyPairRequest request = config.createKeyGenRequest(keystoreFile);
        try {
            KeyToolResult result = this.keyTool.execute((KeyToolRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not sign jar " + keystoreFile, (Exception)exception);
            }
        }
        catch (KeyToolException e) {
            throw new MojoExecutionException("Could not find keytool", (Exception)((Object)e));
        }
    }

    public void sign(SignConfig config, File jarFile, File signedJar) throws MojoExecutionException {
        JarSignerRequest request = config.createSignRequest(jarFile, signedJar);
        try {
            JarSignerResult result = this.jarSigner.execute(request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not sign jar " + jarFile, (Exception)exception);
            }
        }
        catch (JarSignerException e) {
            throw new MojoExecutionException("Could not find jarSigner", (Exception)((Object)e));
        }
    }

    public void verify(SignConfig config, File jarFile, boolean certs) throws MojoExecutionException {
        JarSignerVerifyRequest request = config.createVerifyRequest(jarFile, certs);
        try {
            JarSignerResult result = this.jarSigner.execute((JarSignerRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not verify jar " + jarFile, (Exception)exception);
            }
        }
        catch (JarSignerException e) {
            throw new MojoExecutionException("Could not find jarSigner", (Exception)((Object)e));
        }
    }

    public boolean isJarSigned(SignConfig config, File jarFile) throws MojoExecutionException {
        JarSignerVerifyRequest request = config.createVerifyRequest(jarFile, false);
        LineMatcherStreamConsumer consumer = new LineMatcherStreamConsumer(config.isVerbose(), "jar verified.");
        request.setSystemOutStreamConsumer((StreamConsumer)consumer);
        try {
            JarSignerResult result = this.jarSigner.execute((JarSignerRequest)request);
            CommandLineException exception = result.getExecutionException();
            if (exception != null) {
                throw new MojoExecutionException("Could not verify jar " + jarFile, (Exception)exception);
            }
            return consumer.matched;
        }
        catch (JarSignerException e) {
            throw new MojoExecutionException("Could not find jarSigner", (Exception)((Object)e));
        }
    }

    public void unsign(File jarFile, File tempDirectory, boolean verbose) throws MojoExecutionException {
        String archiveExt = FileUtils.getExtension((String)jarFile.getAbsolutePath()).toLowerCase();
        File tempDir = new File(tempDirectory, jarFile.getName());
        if (!tempDir.mkdirs()) {
            throw new MojoExecutionException("Error creating temporary directory: " + tempDir);
        }
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(jarFile);
            unArchiver.setDestDirectory(tempDir);
            unArchiver.extract();
        }
        catch (ArchiverException ex) {
            throw new MojoExecutionException("Error unpacking file: " + jarFile + "to: " + tempDir, (Exception)((Object)ex));
        }
        catch (NoSuchArchiverException ex) {
            throw new MojoExecutionException("Error acquiring unarchiver for extension: " + archiveExt, (Exception)((Object)ex));
        }
        File metaInf = new File(tempDir, "META-INF");
        if (!metaInf.isDirectory()) {
            this.verboseLog(verbose, "META-INF dir not found : nothing to do for file: " + jarFile.getAbsolutePath());
            return;
        }
        File[] filesToRemove = metaInf.listFiles(this.removeSignatureFileFilter);
        if (filesToRemove.length == 0) {
            this.verboseLog(verbose, "no files match " + Arrays.asList(EXT_ARRAY) + " : nothing to do for file: " + jarFile.getAbsolutePath());
            return;
        }
        for (int i = 0; i < filesToRemove.length; ++i) {
            if (!filesToRemove[i].delete()) {
                throw new MojoExecutionException("Error removing signature file: " + filesToRemove[i]);
            }
            this.verboseLog(verbose, "remove file :" + filesToRemove[i]);
        }
        try {
            JarArchiver jarArchiver = (JarArchiver)this.archiverManager.getArchiver("jar");
            jarArchiver.setUpdateMode(false);
            jarArchiver.addDirectory(tempDir);
            jarArchiver.setDestFile(jarFile);
            jarArchiver.createArchive();
        }
        catch (ArchiverException ex) {
            throw new MojoExecutionException("Error packing directory: " + tempDir + "to: " + jarFile, (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error packing directory: " + tempDir + "to: " + jarFile, (Exception)ex);
        }
        catch (NoSuchArchiverException ex) {
            throw new MojoExecutionException("Error acquiring archiver for extension: jar", (Exception)((Object)ex));
        }
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error cleaning up temporary directory file: " + tempDir, (Exception)ex);
        }
    }

    public void deleteKeyStore(File keystore, boolean verbose) {
        if (keystore.exists()) {
            if (keystore.delete()) {
                this.infoOrDebug(verbose, "deleted keystore from: " + keystore.getAbsolutePath());
            } else {
                this.getLogger().warn("Couldn't delete keystore from: " + keystore.getAbsolutePath());
            }
        } else {
            this.infoOrDebug(verbose, "Skipping deletion of non existing keystore: " + keystore.getAbsolutePath());
        }
    }

    protected void verboseLog(boolean verbose, String msg) {
        this.infoOrDebug(verbose || this.getLogger().isInfoEnabled(), msg);
    }

    private void infoOrDebug(boolean info, String msg) {
        if (info) {
            this.getLogger().info(msg);
        } else {
            this.getLogger().debug(msg);
        }
    }

    static /* synthetic */ String[] access$000() {
        return EXT_ARRAY;
    }

    private class LineMatcherStreamConsumer
    implements StreamConsumer {
        private String toMatch;
        private boolean matched;
        private boolean verbose;

        LineMatcherStreamConsumer(boolean verbose, String toMatch) {
            this.toMatch = toMatch;
            this.verbose = verbose;
        }

        public void consumeLine(String line) {
            boolean bl = this.matched = this.matched || this.toMatch.equals(line);
            if (this.verbose) {
                DefaultSignTool.this.getLogger().info(line);
            } else {
                DefaultSignTool.this.getLogger().debug(line);
            }
        }
    }
}

