/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:weblogic-maven-plugin:2.9.5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Mojo's Maven plugin for WebLogic", 0);
        this.append(sb, "This plugin will support various tasks within the Weblogic 8.1, 9.x, 10.x and 12.x environment. This version starts to support weblogic 10 and 11. The mojo supports such tasks as deploy, undeploy,clientgen,servicegen, and appc are supported as well as many others. The plugin uses exposed API's that are subject to change but have been tested in 8.1 SP 4-6 and 9.0 - 9.2 MP3, 10.x. There are two versions of the plugin to support the two environments based on differences in the JDK. The 9.x version is currently being refactored to support the standard JSR supported deployment interface. The code used in the plugin has been contributed to the Cargo project however to date has not be integrated into the codebase. Please feel free to suggest improvements or help support this plugin effort.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 12 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "appc".equals(this.goal)) {
            this.append(sb, "weblogic:appc", 0);
            this.append(sb, "Run the weblogic appc compiler against an artifact.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basicClientJar (Default: false)", 2);
                this.append(sb, "If set to true the basic client jar will be created without descriptors, etc.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clientJarOutputDir (Default: ${project.build.directory})", 2);
                this.append(sb, "The full path to create the generated client jar file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueCompilation (Default: true)", 2);
                this.append(sb, "If set to false the plugin stops after if compilation of a JSP file fails.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceGeneration (Default: true)", 2);
                this.append(sb, "If set to true the generation of JSP and EJB s will be forced to happen.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputArtifactPath", 2);
                this.append(sb, "The full path to the artifact to be compiled. It can be an EAR, War or Jar. If the project packaging is ejb then the .ejb suffix will be replaced with .jar if needed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}.${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepGenerated (Default: true)", 2);
                this.append(sb, "If set to true the generated source files will be kept.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineNumbers (Default: false)", 2);
                this.append(sb, "If set to true then line numbers will be added to classes for debugging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputArtifactPath", 2);
                this.append(sb, "The full path to the output artifact. By default it is not used and defaults to be the same as the input.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectPackaging", 2);
                this.append(sb, "The project packaging used to check the suffix on the artifact.", 3);
                this.append(sb, "Expression: ${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "If this is set to true then verbose output for the process will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "clientgen9".equals(this.goal)) {
            this.append(sb, "weblogic:clientgen9", 0);
            this.append(sb, "Runs Client Gen on a given WSDL. This client gen uses the BEA refactored client gen tool first appearing in weblogic 9. This is the preferred client gen tool for Weblogic 9.0 and newer.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "autotype (Default: true)", 2);
                this.append(sb, "Sets whether or not to create the type conversions for a web service in the client.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindingFile", 2);
                this.append(sb, "The binding files", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "The debug setting", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateAsyncMethods (Default: false)", 2);
                this.append(sb, "Sets whether or not to use the async method wrappers", 3);
                this.append(sb, "", 0);
                this.append(sb, "handlerChainFile", 2);
                this.append(sb, "The client handler chain configuration file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputWSDL", 2);
                this.append(sb, "The wsdl to client gen from. If warFileName is specified, this parameter is the root relative file to use when creating the URI for the wsdl.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jaxRPCWrappedArrayStyle (Default: true)", 2);
                this.append(sb, "Sets whether or not to use the jaxRPCWrappedArrayStyle", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDir (Default: ${basedir}/src/main/java)", 2);
                this.append(sb, "The directory to output the generated code to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageName (Default: com.test.webservice)", 2);
                this.append(sb, "The package name of the output code.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceName", 2);
                this.append(sb, "The name of the service.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipClientGen (Default: false)", 2);
                this.append(sb, "Set this to skip JWSC compiling", 3);
                this.append(sb, "Expression: ${weblogic.clientgen.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "useServerTypes (Default: false)", 2);
                this.append(sb, "Whether or not to use server types from the ear file in the client jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Output verbose messages", 3);
                this.append(sb, "", 0);
                this.append(sb, "warFileName", 2);
                this.append(sb, "The filename of the war file to find the services. The file path is extracted from the artifact list.", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
                this.append(sb, "wsType (Default: JAXRPC)", 2);
                this.append(sb, "Set this to set the JWS tpe", 3);
                this.append(sb, "Expression: ${weblogic.jwsc.type}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "weblogic:deploy", 0);
            this.append(sb, "Deploy an artifact to Weblogic servers(s) or cluster(s).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adminServerHostName (Default: localhost)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerPort (Default: 7001)", 2);
                this.append(sb, "The admin port of the Weblogic Admin Server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerProtocol (Default: t3)", 2);
                this.append(sb, "The protocol to use to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactPath", 2);
                this.append(sb, "The full path to artifact to be deployed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueOnFailure (Default: false)", 2);
                this.append(sb, "If set to true, the deployer will not stop if a failure is detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreFileName", 2);
                this.append(sb, "Set fully qualified name to the key store file", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStorePassPhrase", 2);
                this.append(sb, "Set passphrase for the keystore", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStorePassPhrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreType (Default: JKS)", 2);
                this.append(sb, "Set keystore type. Usually JKS", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "demoTrustKeyStore (Default: false)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.demoTrustKeyStore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployEjb (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deployEjb}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentPlanPath", 2);
                this.append(sb, "Deploy the target with the referenced deployment plan", 3);
                this.append(sb, "Expression: ${weblogic.deploymentPlanPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exploded (Default: false)", 2);
                this.append(sb, "Set to true to do exploded deployments", 3);
                this.append(sb, "Expression: ${weblogic.exploded}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreHostnameVerification (Default: true)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.ignoreHostnameVerification}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name to use when deploying the object.", 3);
                this.append(sb, "Expression: ${project.artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noExit (Default: false)", 2);
                this.append(sb, "tell weblogic to not exit if there is a deployment failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVersion (Default: false)", 2);
                this.append(sb, "Tell weblogic to ignore the versions an apply the task to all versions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "Set this value to true so weblogic will return immediately", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: weblogic)", 2);
                this.append(sb, "The admin password to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectPackaging", 2);
                this.append(sb, "The project packaging used to check the suffix on the artifact.", 3);
                this.append(sb, "Expression: ${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remote (Default: false)", 2);
                this.append(sb, "True if you are running on a machine that is remote to the admin server. If this is a remote deployment and this is set to false then it is assumed that all source paths are valid paths on the admin server.", 3);
                this.append(sb, "Expression: ${weblogic.remote}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deploy.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stage (Default: true)", 2);
                this.append(sb, "True if you want to turn off staging", 3);
                this.append(sb, "Expression: ${weblogic.stage}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetNames (Default: AdminServer)", 2);
                this.append(sb, "A comma seperated list of names of servers or clusters to deploy the artifact onto.", 3);
                this.append(sb, "Expression: ${weblogic.targetNames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: -1)", 2);
                this.append(sb, "Set this value to the timeout seconds. Set to <=0 to disable", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "upload (Default: false)", 2);
                this.append(sb, "Set to true to upload the code.", 3);
                this.append(sb, "Expression: ${weblogic.upload}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfigFile", 2);
                this.append(sb, "The user config file to use", 3);
                this.append(sb, "Expression: ${weblogic.userConfigFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: weblogic)", 2);
                this.append(sb, "The Admin UserId to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.user}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userKeyFile", 2);
                this.append(sb, "The default user key file to use", 3);
                this.append(sb, "Expression: ${weblogic.userKeyFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: true)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: false)", 2);
                this.append(sb, "Print the version for weblogic", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "weblogic:help", 0);
            this.append(sb, "Display help information on weblogic-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0weblogic:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jwsc".equals(this.goal)) {
            this.append(sb, "weblogic:jwsc", 0);
            this.append(sb, "Runs the JWSC compiler task for web service enabled code.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "contextPath", 2);
                this.append(sb, "The deployed context of the web service.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "The flag to set when debugging the process", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptor", 2);
                this.append(sb, "The web.xml descriptor to use if a new one should not be generated. The path should be fully qualified.\nIf there is more than one descriptor, use a comma ',' separated list.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "explode (Default: true)", 2);
                this.append(sb, "The flag to set when wanting exploded output. Defaults to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputDir (Default: ${basedir}/src/main/java)", 2);
                this.append(sb, "The directory to find the jwsc enabled files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jwscTaskType (Default: JAXRPC)", 2);
                this.append(sb, "The task type JAXRPC JAXWS", 3);
                this.append(sb, "Expression: ${weblogic.jwsc.type}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepGenerated (Default: false)", 2);
                this.append(sb, "The keep generated flag for the mojo", 3);
                this.append(sb, "Expression: ${weblogic.jwsc.keepGenerated}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "optimize (Default: true)", 2);
                this.append(sb, "The flag to set when requiring optimization. Defaults to true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDir (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory to output the generated code to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputName (Default: ${project.artifactId}-${project.version})", 2);
                this.append(sb, "The name of the war to use when evaluating the ear file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceExcludes", 2);
                this.append(sb, "The explicit includes list for the file set", 3);
                this.append(sb, "Expression: ${weblogic.jwsc.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceIncludes (Default: **/*.java)", 2);
                this.append(sb, "The explicit includes list for the file set", 3);
                this.append(sb, "Expression: ${weblogic.jwsc.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "The flag to set when desiring verbose output", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "listapps".equals(this.goal)) {
            this.append(sb, "weblogic:listapps", 0);
            this.append(sb, "List the atifacts on Weblogic server(s) or cluster(s).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adminServerHostName (Default: localhost)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerPort (Default: 7001)", 2);
                this.append(sb, "The admin port of the Weblogic Admin Server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerProtocol (Default: t3)", 2);
                this.append(sb, "The protocol to use to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactPath", 2);
                this.append(sb, "The full path to artifact to be deployed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueOnFailure (Default: false)", 2);
                this.append(sb, "If set to true, the deployer will not stop if a failure is detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreFileName", 2);
                this.append(sb, "Set fully qualified name to the key store file", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStorePassPhrase", 2);
                this.append(sb, "Set passphrase for the keystore", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStorePassPhrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreType (Default: JKS)", 2);
                this.append(sb, "Set keystore type. Usually JKS", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "demoTrustKeyStore (Default: false)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.demoTrustKeyStore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployEjb (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deployEjb}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentPlanPath", 2);
                this.append(sb, "Deploy the target with the referenced deployment plan", 3);
                this.append(sb, "Expression: ${weblogic.deploymentPlanPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exploded (Default: false)", 2);
                this.append(sb, "Set to true to do exploded deployments", 3);
                this.append(sb, "Expression: ${weblogic.exploded}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreHostnameVerification (Default: true)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.ignoreHostnameVerification}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name to use when deploying the object.", 3);
                this.append(sb, "Expression: ${project.artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noExit (Default: false)", 2);
                this.append(sb, "tell weblogic to not exit if there is a deployment failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVersion (Default: false)", 2);
                this.append(sb, "Tell weblogic to ignore the versions an apply the task to all versions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "Set this value to true so weblogic will return immediately", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: weblogic)", 2);
                this.append(sb, "The admin password to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectPackaging", 2);
                this.append(sb, "The project packaging used to check the suffix on the artifact.", 3);
                this.append(sb, "Expression: ${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remote (Default: false)", 2);
                this.append(sb, "True if you are running on a machine that is remote to the admin server. If this is a remote deployment and this is set to false then it is assumed that all source paths are valid paths on the admin server.", 3);
                this.append(sb, "Expression: ${weblogic.remote}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deploy.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stage (Default: true)", 2);
                this.append(sb, "True if you want to turn off staging", 3);
                this.append(sb, "Expression: ${weblogic.stage}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetNames (Default: AdminServer)", 2);
                this.append(sb, "A comma seperated list of names of servers or clusters to deploy the artifact onto.", 3);
                this.append(sb, "Expression: ${weblogic.targetNames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: -1)", 2);
                this.append(sb, "Set this value to the timeout seconds. Set to <=0 to disable", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "upload (Default: false)", 2);
                this.append(sb, "Set to true to upload the code.", 3);
                this.append(sb, "Expression: ${weblogic.upload}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfigFile", 2);
                this.append(sb, "The user config file to use", 3);
                this.append(sb, "Expression: ${weblogic.userConfigFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: weblogic)", 2);
                this.append(sb, "The Admin UserId to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.user}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userKeyFile", 2);
                this.append(sb, "The default user key file to use", 3);
                this.append(sb, "Expression: ${weblogic.userKeyFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: true)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: false)", 2);
                this.append(sb, "Print the version for weblogic", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "redeploy".equals(this.goal)) {
            this.append(sb, "weblogic:redeploy", 0);
            this.append(sb, "Redeploy artifact on Weblogic server(s) or cluster(s).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adminServerHostName (Default: localhost)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerPort (Default: 7001)", 2);
                this.append(sb, "The admin port of the Weblogic Admin Server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerProtocol (Default: t3)", 2);
                this.append(sb, "The protocol to use to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactPath", 2);
                this.append(sb, "The full path to artifact to be deployed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueOnFailure (Default: false)", 2);
                this.append(sb, "If set to true, the deployer will not stop if a failure is detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreFileName", 2);
                this.append(sb, "Set fully qualified name to the key store file", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStorePassPhrase", 2);
                this.append(sb, "Set passphrase for the keystore", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStorePassPhrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreType (Default: JKS)", 2);
                this.append(sb, "Set keystore type. Usually JKS", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "demoTrustKeyStore (Default: false)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.demoTrustKeyStore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployEjb (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deployEjb}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentPlanPath", 2);
                this.append(sb, "Deploy the target with the referenced deployment plan", 3);
                this.append(sb, "Expression: ${weblogic.deploymentPlanPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exploded (Default: false)", 2);
                this.append(sb, "Set to true to do exploded deployments", 3);
                this.append(sb, "Expression: ${weblogic.exploded}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreHostnameVerification (Default: true)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.ignoreHostnameVerification}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name to use when deploying the object.", 3);
                this.append(sb, "Expression: ${project.artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noExit (Default: false)", 2);
                this.append(sb, "tell weblogic to not exit if there is a deployment failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVersion (Default: false)", 2);
                this.append(sb, "Tell weblogic to ignore the versions an apply the task to all versions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "Set this value to true so weblogic will return immediately", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: weblogic)", 2);
                this.append(sb, "The admin password to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectPackaging", 2);
                this.append(sb, "The project packaging used to check the suffix on the artifact.", 3);
                this.append(sb, "Expression: ${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remote (Default: false)", 2);
                this.append(sb, "True if you are running on a machine that is remote to the admin server. If this is a remote deployment and this is set to false then it is assumed that all source paths are valid paths on the admin server.", 3);
                this.append(sb, "Expression: ${weblogic.remote}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deploy.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stage (Default: true)", 2);
                this.append(sb, "True if you want to turn off staging", 3);
                this.append(sb, "Expression: ${weblogic.stage}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetNames (Default: AdminServer)", 2);
                this.append(sb, "A comma seperated list of names of servers or clusters to deploy the artifact onto.", 3);
                this.append(sb, "Expression: ${weblogic.targetNames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: -1)", 2);
                this.append(sb, "Set this value to the timeout seconds. Set to <=0 to disable", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "upload (Default: false)", 2);
                this.append(sb, "Set to true to upload the code.", 3);
                this.append(sb, "Expression: ${weblogic.upload}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfigFile", 2);
                this.append(sb, "The user config file to use", 3);
                this.append(sb, "Expression: ${weblogic.userConfigFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: weblogic)", 2);
                this.append(sb, "The Admin UserId to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.user}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userKeyFile", 2);
                this.append(sb, "The default user key file to use", 3);
                this.append(sb, "Expression: ${weblogic.userKeyFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: true)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: false)", 2);
                this.append(sb, "Print the version for weblogic", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "servicegen".equals(this.goal)) {
            this.append(sb, "weblogic:servicegen", 0);
            this.append(sb, "Runs Service Gen on a given WSDL.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "contextUri", 2);
                this.append(sb, "The context uri for the service", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputArtifactPath", 2);
                this.append(sb, "The full path to the artifact to be compiled. It can be an EAR, War or Jar. If the project packaging is ejb then the .ejb suffix will be replaced with .jar if needed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}.${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDir (Default: ${basedir}/src/main/java)", 2);
                this.append(sb, "The directory to output the geneated code to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageName (Default: com.test.webservice)", 2);
                this.append(sb, "The package name of the output code.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "services", 2);
                this.append(sb, "The service configurations to generate", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "warName", 2);
                this.append(sb, "this is the name of the war to execute the service gen against.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start".equals(this.goal)) {
            this.append(sb, "weblogic:start", 0);
            this.append(sb, "Start an artifact on Weblogic server(s) or cluster(s).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adminServerHostName (Default: localhost)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerPort (Default: 7001)", 2);
                this.append(sb, "The admin port of the Weblogic Admin Server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerProtocol (Default: t3)", 2);
                this.append(sb, "The protocol to use to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactPath", 2);
                this.append(sb, "The full path to artifact to be deployed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueOnFailure (Default: false)", 2);
                this.append(sb, "If set to true, the deployer will not stop if a failure is detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreFileName", 2);
                this.append(sb, "Set fully qualified name to the key store file", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStorePassPhrase", 2);
                this.append(sb, "Set passphrase for the keystore", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStorePassPhrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreType (Default: JKS)", 2);
                this.append(sb, "Set keystore type. Usually JKS", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "demoTrustKeyStore (Default: false)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.demoTrustKeyStore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployEjb (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deployEjb}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentPlanPath", 2);
                this.append(sb, "Deploy the target with the referenced deployment plan", 3);
                this.append(sb, "Expression: ${weblogic.deploymentPlanPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exploded (Default: false)", 2);
                this.append(sb, "Set to true to do exploded deployments", 3);
                this.append(sb, "Expression: ${weblogic.exploded}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreHostnameVerification (Default: true)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.ignoreHostnameVerification}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name to use when deploying the object.", 3);
                this.append(sb, "Expression: ${project.artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noExit (Default: false)", 2);
                this.append(sb, "tell weblogic to not exit if there is a deployment failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVersion (Default: false)", 2);
                this.append(sb, "Tell weblogic to ignore the versions an apply the task to all versions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "Set this value to true so weblogic will return immediately", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: weblogic)", 2);
                this.append(sb, "The admin password to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectPackaging", 2);
                this.append(sb, "The project packaging used to check the suffix on the artifact.", 3);
                this.append(sb, "Expression: ${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remote (Default: false)", 2);
                this.append(sb, "True if you are running on a machine that is remote to the admin server. If this is a remote deployment and this is set to false then it is assumed that all source paths are valid paths on the admin server.", 3);
                this.append(sb, "Expression: ${weblogic.remote}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deploy.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stage (Default: true)", 2);
                this.append(sb, "True if you want to turn off staging", 3);
                this.append(sb, "Expression: ${weblogic.stage}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetNames (Default: AdminServer)", 2);
                this.append(sb, "A comma seperated list of names of servers or clusters to deploy the artifact onto.", 3);
                this.append(sb, "Expression: ${weblogic.targetNames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: -1)", 2);
                this.append(sb, "Set this value to the timeout seconds. Set to <=0 to disable", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "upload (Default: false)", 2);
                this.append(sb, "Set to true to upload the code.", 3);
                this.append(sb, "Expression: ${weblogic.upload}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfigFile", 2);
                this.append(sb, "The user config file to use", 3);
                this.append(sb, "Expression: ${weblogic.userConfigFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: weblogic)", 2);
                this.append(sb, "The Admin UserId to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.user}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userKeyFile", 2);
                this.append(sb, "The default user key file to use", 3);
                this.append(sb, "Expression: ${weblogic.userKeyFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: true)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: false)", 2);
                this.append(sb, "Print the version for weblogic", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop".equals(this.goal)) {
            this.append(sb, "weblogic:stop", 0);
            this.append(sb, "Stop an artifact on Weblogic server(s) or cluster(s).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adminServerHostName (Default: localhost)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerPort (Default: 7001)", 2);
                this.append(sb, "The admin port of the Weblogic Admin Server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerProtocol (Default: t3)", 2);
                this.append(sb, "The protocol to use to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactPath", 2);
                this.append(sb, "The full path to artifact to be deployed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueOnFailure (Default: false)", 2);
                this.append(sb, "If set to true, the deployer will not stop if a failure is detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreFileName", 2);
                this.append(sb, "Set fully qualified name to the key store file", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStorePassPhrase", 2);
                this.append(sb, "Set passphrase for the keystore", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStorePassPhrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreType (Default: JKS)", 2);
                this.append(sb, "Set keystore type. Usually JKS", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "demoTrustKeyStore (Default: false)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.demoTrustKeyStore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployEjb (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deployEjb}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentPlanPath", 2);
                this.append(sb, "Deploy the target with the referenced deployment plan", 3);
                this.append(sb, "Expression: ${weblogic.deploymentPlanPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exploded (Default: false)", 2);
                this.append(sb, "Set to true to do exploded deployments", 3);
                this.append(sb, "Expression: ${weblogic.exploded}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreHostnameVerification (Default: true)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.ignoreHostnameVerification}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name to use when deploying the object.", 3);
                this.append(sb, "Expression: ${project.artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noExit (Default: false)", 2);
                this.append(sb, "tell weblogic to not exit if there is a deployment failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVersion (Default: false)", 2);
                this.append(sb, "Tell weblogic to ignore the versions an apply the task to all versions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "Set this value to true so weblogic will return immediately", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: weblogic)", 2);
                this.append(sb, "The admin password to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectPackaging", 2);
                this.append(sb, "The project packaging used to check the suffix on the artifact.", 3);
                this.append(sb, "Expression: ${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remote (Default: false)", 2);
                this.append(sb, "True if you are running on a machine that is remote to the admin server. If this is a remote deployment and this is set to false then it is assumed that all source paths are valid paths on the admin server.", 3);
                this.append(sb, "Expression: ${weblogic.remote}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deploy.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stage (Default: true)", 2);
                this.append(sb, "True if you want to turn off staging", 3);
                this.append(sb, "Expression: ${weblogic.stage}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetNames (Default: AdminServer)", 2);
                this.append(sb, "A comma seperated list of names of servers or clusters to deploy the artifact onto.", 3);
                this.append(sb, "Expression: ${weblogic.targetNames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: -1)", 2);
                this.append(sb, "Set this value to the timeout seconds. Set to <=0 to disable", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "upload (Default: false)", 2);
                this.append(sb, "Set to true to upload the code.", 3);
                this.append(sb, "Expression: ${weblogic.upload}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfigFile", 2);
                this.append(sb, "The user config file to use", 3);
                this.append(sb, "Expression: ${weblogic.userConfigFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: weblogic)", 2);
                this.append(sb, "The Admin UserId to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.user}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userKeyFile", 2);
                this.append(sb, "The default user key file to use", 3);
                this.append(sb, "Expression: ${weblogic.userKeyFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: true)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: false)", 2);
                this.append(sb, "Print the version for weblogic", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "undeploy".equals(this.goal)) {
            this.append(sb, "weblogic:undeploy", 0);
            this.append(sb, "Undeploy artifacts from Weblogic server(s) or cluster(s).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "adminServerHostName (Default: localhost)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.hostName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerPort (Default: 7001)", 2);
                this.append(sb, "The admin port of the Weblogic Admin Server.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "adminServerProtocol (Default: t3)", 2);
                this.append(sb, "The protocol to use to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.adminServer.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactPath", 2);
                this.append(sb, "The full path to artifact to be deployed.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueOnFailure (Default: false)", 2);
                this.append(sb, "If set to true, the deployer will not stop if a failure is detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreFileName", 2);
                this.append(sb, "Set fully qualified name to the key store file", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreFileName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStorePassPhrase", 2);
                this.append(sb, "Set passphrase for the keystore", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStorePassPhrase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "customTrustKeyStoreType (Default: JKS)", 2);
                this.append(sb, "Set keystore type. Usually JKS", 3);
                this.append(sb, "Expression: ${weblogic.customTrustKeyStoreType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "demoTrustKeyStore (Default: false)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.demoTrustKeyStore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployEjb (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deployEjb}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deploymentPlanPath", 2);
                this.append(sb, "Deploy the target with the referenced deployment plan", 3);
                this.append(sb, "Expression: ${weblogic.deploymentPlanPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "exploded (Default: false)", 2);
                this.append(sb, "Set to true to do exploded deployments", 3);
                this.append(sb, "Expression: ${weblogic.exploded}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreHostnameVerification (Default: true)", 2);
                this.append(sb, "Set to true for the demo trust key store", 3);
                this.append(sb, "Expression: ${weblogic.ignoreHostnameVerification}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "name", 2);
                this.append(sb, "The name to use when deploying the object.", 3);
                this.append(sb, "Expression: ${project.artifactId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noExit (Default: false)", 2);
                this.append(sb, "tell weblogic to not exit if there is a deployment failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noVersion (Default: false)", 2);
                this.append(sb, "Tell weblogic to ignore the versions an apply the task to all versions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "Set this value to true so weblogic will return immediately", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password (Default: weblogic)", 2);
                this.append(sb, "The admin password to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectPackaging", 2);
                this.append(sb, "The project packaging used to check the suffix on the artifact.", 3);
                this.append(sb, "Expression: ${project.packaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remote (Default: false)", 2);
                this.append(sb, "True if you are running on a machine that is remote to the admin server. If this is a remote deployment and this is set to false then it is assumed that all source paths are valid paths on the admin server.", 3);
                this.append(sb, "Expression: ${weblogic.remote}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "The dns hostname of the Weblogic Admin server.", 3);
                this.append(sb, "Expression: ${weblogic.deploy.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "stage (Default: true)", 2);
                this.append(sb, "True if you want to turn off staging", 3);
                this.append(sb, "Expression: ${weblogic.stage}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetNames (Default: AdminServer)", 2);
                this.append(sb, "A comma seperated list of names of servers or clusters to deploy the artifact onto.", 3);
                this.append(sb, "Expression: ${weblogic.targetNames}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: -1)", 2);
                this.append(sb, "Set this value to the timeout seconds. Set to <=0 to disable", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "upload (Default: false)", 2);
                this.append(sb, "Set to true to upload the code.", 3);
                this.append(sb, "Expression: ${weblogic.upload}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userConfigFile", 2);
                this.append(sb, "The user config file to use", 3);
                this.append(sb, "Expression: ${weblogic.userConfigFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userId (Default: weblogic)", 2);
                this.append(sb, "The Admin UserId to access the Weblogic Admin server for deployment.", 3);
                this.append(sb, "Expression: ${weblogic.user}", 3);
                this.append(sb, "", 0);
                this.append(sb, "userKeyFile", 2);
                this.append(sb, "The default user key file to use", 3);
                this.append(sb, "Expression: ${weblogic.userKeyFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: true)", 2);
                this.append(sb, "True to turn on debugging", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: false)", 2);
                this.append(sb, "Print the version for weblogic", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsdlgen".equals(this.goal)) {
            this.append(sb, "weblogic:wsdlgen", 0);
            this.append(sb, "This class generates wsdl from ear/war package", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "defaultEndpoint (Default: http://localhost:7001/)", 2);
                this.append(sb, "The default endpoint address", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "The local repository", 3);
                this.append(sb, "Expression: ${localRepository}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "This is the output directory for the artifacts. It defaults to $project.build.directory.", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: true)", 2);
                this.append(sb, "Set to false to not overwrite existing resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "These are the plugin artifacts for the weblogic mojo", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteRepositories", 2);
                this.append(sb, "The list of remote repositories", 3);
                this.append(sb, "Expression: ${project.remoteArtifactRepositories}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceName", 2);
                this.append(sb, "The service name to generate the wsdl for", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "toolsJar", 2);
                this.append(sb, "The the location of tools.jar file. this file must be dynamically added to the classloader due to some issues with the way maven works and a bug in jdk 1.6\nNote that the java.home location should be to the jre not the jdk", 3);
                this.append(sb, "Expression: ${java.home}/../lib/tools.jar", 3);
                this.append(sb, "", 0);
                this.append(sb, "warName", 2);
                this.append(sb, "The war name inside of the ear that contains the services", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "weblogicHome (Default: ${weblogic.home})", 2);
                this.append(sb, "Property to set the weblogic home", 3);
                this.append(sb, "", 0);
                this.append(sb, "wsdlFile", 2);
                this.append(sb, "The wsdl file to output when complete.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}.wsdl", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

