/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.wsee.tools.anttasks.ClientGenTask;

public class ClientGen9Mojo
extends AbstractWeblogicMojo {
    private String warFileName;
    private String inputWSDL;
    private String outputDir;
    private String packageName;
    private String serviceName;
    private boolean verbose;
    private boolean useServerTypes;
    private boolean autotype;
    private boolean jaxRPCWrappedArrayStyle;

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic client gen beginning ");
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)(" Detailed client gen settings information " + this.toString()));
        }
        try {
            String wsdlUri;
            ClientGenTask clientGen = new ClientGenTask();
            Project project = new Project();
            project.setName("clientgen");
            Path path = new Path(project, WeblogicMojoUtilities.getDependencies(this.getArtifacts(), this.getPluginArtifacts()));
            clientGen.setProject(project);
            clientGen.setClasspath(path);
            clientGen.setOverwrite(true);
            clientGen.setVerbose(this.verbose);
            clientGen.setDestdir(new File(this.outputDir));
            clientGen.setPackageName(this.packageName);
            clientGen.setIncludeGlobalTypes(this.useServerTypes);
            clientGen.setJaxRPCWrappedArrayStyle(this.jaxRPCWrappedArrayStyle);
            if (this.warFileName != null) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" calculating wsdl URI from warFileName " + this.warFileName + " with wsdl " + this.inputWSDL));
                }
                wsdlUri = "jar:file:" + WeblogicMojoUtilities.getWarFileName(this.getArtifacts(), this.warFileName) + "!" + this.inputWSDL;
                new File(this.inputWSDL).toURI().toString();
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" using " + wsdlUri + " for clientgen."));
                }
            } else if (this.inputWSDL.startsWith("http")) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" using " + this.inputWSDL + " for clientgen."));
                }
                wsdlUri = this.inputWSDL;
            } else {
                wsdlUri = new File(this.inputWSDL).toURI().toString();
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" using " + wsdlUri + " for clientgen."));
                }
            }
            clientGen.setWsdl(wsdlUri);
            if (this.serviceName != null) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" generating client for service '" + this.serviceName + "'."));
                }
                clientGen.setServiceName(this.serviceName);
            }
            clientGen.execute();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during client gen", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during listapps", ex);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic client gen successful ");
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String inInputWSDL) {
        this.inputWSDL = inInputWSDL;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String inOutputDir) {
        this.outputDir = inOutputDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String inServiceName) {
        this.serviceName = inServiceName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClientGen9Mojo[");
        buffer.append("inputWSDL = ").append(this.inputWSDL);
        buffer.append(", outputDir = ").append(this.outputDir);
        buffer.append(", packageName = ").append(this.packageName);
        buffer.append(", serviceName = ").append(this.serviceName);
        buffer.append(", useServerTypes = ").append(this.useServerTypes);
        buffer.append(", autotype = ").append(this.autotype);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean isUseServerTypes() {
        return this.useServerTypes;
    }

    public void setUseServerTypes(boolean useServerTypes) {
        this.useServerTypes = useServerTypes;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isAutotype() {
        return this.autotype;
    }

    public void setAutotype(boolean autotype) {
        this.autotype = autotype;
    }

    public String getWarFileName() {
        return this.warFileName;
    }

    public void setWarFileName(String warFileName) {
        this.warFileName = warFileName;
    }

    public boolean isJaxRPCWrappedArrayStyle() {
        return this.jaxRPCWrappedArrayStyle;
    }

    public void setJaxRPCWrappedArrayStyle(boolean jaxRPCWrappedArrayStyle) {
        this.jaxRPCWrappedArrayStyle = jaxRPCWrappedArrayStyle;
    }
}

