/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;

public class DependencyBuilder {
    private static final Dependency TEMPLATE = new Dependency();
    private String groupId = TEMPLATE.getGroupId();
    private String artifactId = TEMPLATE.getArtifactId();
    private String version = TEMPLATE.getVersion();
    private String type = TEMPLATE.getType();
    private String classifier = TEMPLATE.getClassifier();
    private String scope = TEMPLATE.getScope();
    private String optional = TEMPLATE.getOptional();
    private final Map<String, InputLocation> inputLocationMap = new HashMap<String, InputLocation>();

    private DependencyBuilder() {
    }

    public DependencyBuilder withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public DependencyBuilder withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public DependencyBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public DependencyBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public DependencyBuilder withClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public DependencyBuilder withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public DependencyBuilder withOptional(String optional) {
        this.optional = optional;
        return this;
    }

    public DependencyBuilder withOptional(boolean optional) {
        this.optional = String.valueOf(optional);
        return this;
    }

    public DependencyBuilder withLocation(String element, InputLocation location) {
        this.inputLocationMap.put(element, location);
        return this;
    }

    public static DependencyBuilder newBuilder() {
        return new DependencyBuilder();
    }

    public Dependency build() {
        Dependency inst = new Dependency();
        inst.setGroupId(this.groupId);
        inst.setArtifactId(this.artifactId);
        inst.setVersion(this.version);
        inst.setType(this.type);
        inst.setClassifier(this.classifier);
        inst.setScope(this.scope);
        inst.setOptional(this.optional);
        this.inputLocationMap.forEach((arg_0, arg_1) -> ((Dependency)inst).setLocation(arg_0, arg_1));
        return inst;
    }

    public static enum Location {
        GROUP_ID("groupId"),
        ARTIFACT_ID("artifactId"),
        VERSION("version");

        private final String stringValue;

        private Location(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

