/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.eclipse.aether.RepositorySystem;

public abstract class UseLatestVersionsMojoBase
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="numThreads", defaultValue="5")
    private int numThreads = 5;
    private final ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);

    protected abstract boolean getAllowMajorUpdates();

    protected abstract boolean getAllowMinorUpdates();

    protected abstract boolean getAllowIncrementalUpdates();

    protected abstract boolean getAllowDowngrade();

    @Override
    protected abstract boolean getAllowSnapshots();

    protected abstract boolean updateFilter(Dependency var1);

    protected abstract boolean artifactVersionsFilter(ArtifactVersion var1);

    protected abstract Optional<ArtifactVersion> versionProducer(Stream<ArtifactVersion> var1);

    public UseLatestVersionsMojoBase(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        if (this.getAllowDowngrade() && this.getAllowSnapshots()) {
            throw new MojoExecutionException("allowDowngrade is only valid with allowSnapshots equal to false");
        }
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.getAllowMajorUpdates(), (boolean)this.getAllowMinorUpdates(), (boolean)this.getAllowIncrementalUpdates(), (Log)this.getLog());
        ConcurrentLinkedQueue<DependencyVersionChange> versionChanges = new ConcurrentLinkedQueue<DependencyVersionChange>();
        ArrayList<CompletableFuture<Void>> versionChangeFutures = new ArrayList<CompletableFuture<Void>>();
        try {
            Object dependencyManagement;
            if (this.getProcessDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                versionChangeFutures.add(this.getUpdates(versionChanges, dependencyManagement.getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT, unchangedSegment));
            }
            if (this.getProject().getDependencies() != null && this.getProcessDependencies()) {
                versionChangeFutures.add(this.getUpdates(versionChanges, this.getProject().getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY, unchangedSegment));
            }
            if (this.getProject().getParent() != null && this.getProcessParent()) {
                versionChangeFutures.add(this.getUpdates(versionChanges, Collections.singletonList(this.getParentDependency()), DependencyChangeRecord.ChangeKind.PARENT, unchangedSegment));
            }
            CompletableFuture.allOf(versionChangeFutures.toArray(new CompletableFuture[0])).join();
            for (DependencyVersionChange change : versionChanges) {
                this.updateDependencyVersion(this.getProject(), pom, change.getDependency(), change.getNewVersion(), change.getChangeKind());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IllegalStateException) {
                IllegalStateException ise = (IllegalStateException)e.getCause();
                if (ise.getCause() instanceof MojoExecutionException) {
                    throw (MojoExecutionException)ise.getCause();
                }
                if (ise.getCause() instanceof VersionRetrievalException) {
                    throw (VersionRetrievalException)ise.getCause();
                }
            }
            throw e;
        }
    }

    private CompletableFuture<Void> getUpdates(ConcurrentLinkedQueue<DependencyVersionChange> updates, Collection<Dependency> dependencies, DependencyChangeRecord.ChangeKind changeKind, Optional<Segment> unchangedSegment) {
        return CompletableFuture.allOf((CompletableFuture[])dependencies.stream().map(dep -> CompletableFuture.runAsync(() -> {
            if (!this.updateFilter((Dependency)dep)) {
                return;
            }
            if (this.getExcludeReactor() && this.isProducedByReactor((Dependency)dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString((Dependency)dep)));
            } else if (this.isHandledByProperty((Dependency)dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString((Dependency)dep)));
            } else {
                try {
                    Artifact artifact = this.toArtifact((Dependency)dep);
                    if (!this.isIncluded(artifact)) {
                        return;
                    }
                    if (this.getLog().isDebugEnabled()) {
                        ArtifactVersion selectedVersion = ArtifactVersionService.getArtifactVersion((String)dep.getVersion());
                        this.getLog().debug((CharSequence)("Selected version:" + selectedVersion));
                        this.getLog().debug((CharSequence)("Looking for newer versions of " + this.toString((Dependency)dep)));
                    }
                    ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
                    this.versionProducer(Arrays.stream(versions.getNewerVersions(dep.getVersion(), unchangedSegment, this.getAllowSnapshots(), this.getAllowDowngrade())).filter(this::artifactVersionsFilter)).ifPresent(ver -> updates.add(new DependencyVersionChange(changeKind, (Dependency)dep, ver.toString())));
                }
                catch (MojoExecutionException | VersionRetrievalException | InvalidSegmentException e) {
                    throw new IllegalStateException(e);
                }
            }
        }, this.executor)).toArray(CompletableFuture[]::new));
    }

    private static final class DependencyVersionChange
    extends ArtifactVersionChange {
        private final Dependency dependency;

        DependencyVersionChange(DependencyChangeRecord.ChangeKind changeKind, Dependency dependency, String newVersion) {
            super(changeKind, newVersion);
            this.dependency = dependency;
        }

        Dependency getDependency() {
            return this.dependency;
        }
    }

    private static abstract class ArtifactVersionChange {
        private final DependencyChangeRecord.ChangeKind changeKind;
        private final String newVersion;

        ArtifactVersionChange(DependencyChangeRecord.ChangeKind changeKind, String newVersion) {
            this.changeKind = changeKind;
            this.newVersion = newVersion;
        }

        DependencyChangeRecord.ChangeKind getChangeKind() {
            return this.changeKind;
        }

        String getNewVersion() {
            return this.newVersion;
        }
    }
}

