/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven.plugin;

import java.io.File;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.core.AssemblyOperation;
import org.codehaus.mojo.unix.core.CopyFileOperation;
import org.codehaus.mojo.unix.maven.plugin.AssemblyOp;
import org.codehaus.mojo.unix.maven.plugin.MojoFileAttributes;
import org.codehaus.mojo.unix.maven.plugin.UnknownArtifactException;
import org.codehaus.mojo.unix.util.RelativePath;

public class CopyArtifact
extends AssemblyOp {
    private String artifact;
    private RelativePath toFile;
    private RelativePath toDir;
    private MojoFileAttributes attributes = new MojoFileAttributes();

    public CopyArtifact() {
        super("copy-artifact");
    }

    public void setArtifact(String artifact) {
        this.artifact = CopyArtifact.nullifEmpty(artifact);
    }

    public void setToFile(String toFile) {
        this.toFile = RelativePath.relativePath((String)toFile);
    }

    public void setToDir(String toDir) {
        this.toDir = RelativePath.relativePath((String)toDir);
    }

    public void setAttributes(MojoFileAttributes attributes) {
        this.attributes = attributes;
    }

    public AssemblyOperation createOperation(FileObject basedir, FileAttributes defaultFileAttributes, FileAttributes defaultDirectoryAttributes) throws MojoFailureException, FileSystemException, UnknownArtifactException {
        File artifactFile = this.validateArtifact(this.artifact);
        RelativePath toFile = this.validateAndResolveOutputFile(artifactFile, this.toDir, this.toFile);
        return new CopyFileOperation(defaultFileAttributes.useAsDefaultsFor(this.attributes.create()), this.resolve(basedir.getFileSystem(), artifactFile), toFile);
    }
}

