/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:truezip-maven-plugin:1.0-beta-5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Plugin for TrueZIP", 0);
        this.append(sb, "Use this plugin create new or manipulate existing archives", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 8 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "copy".equals(this.goal)) {
            this.append(sb, "truezip:copy", 0);
            this.append(sb, "Copy a set of files in and out of an existing archive", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "files", 2);
                this.append(sb, "The list of FileItem to to manipulate the archive. Use this configuration when you have a need to do copying with option to change file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "A single FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "immediateUpdate (Default: true)", 2);
                this.append(sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose mode", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "cp".equals(this.goal)) {
            this.append(sb, "truezip:cp", 0);
            this.append(sb, "Copy an archive/directory to another archive/directory. Mainly used from command line to unpack/pack any known archive type.\nExample:\n\n-\tmvn truezip:cp -Dfrom=a.zip -Dto=b\n-\tmvn truezip:cp -Dfrom=b -Dto=b.zip\n\n\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "Path to an archive to be unpacked", 3);
                this.append(sb, "", 0);
                this.append(sb, "immediateUpdate (Default: true)", 2);
                this.append(sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "to", 2);
                this.append(sb, "Path to an archive or directory unpack to", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "truezip:help", 0);
            this.append(sb, "Display help information on truezip-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0truezip:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list".equals(this.goal)) {
            this.append(sb, "truezip:list", 0);
            this.append(sb, "List all files in the archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "A single FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "immediateUpdate (Default: true)", 2);
                this.append(sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile", 2);
                this.append(sb, "Write list output to a file if needed", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose mode", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "ls".equals(this.goal)) {
            this.append(sb, "truezip:ls", 0);
            this.append(sb, "Display an archive's list to console. Note: inner archive file length always show 0 byte long. See TrueZip java doc for details.\nExample:\n\n-\tmvn truezip:ls -Dfrom=a.zip\n\n\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "followSubArchive (Default: false)", 2);
                this.append(sb, "Drill beyond sub archive", 3);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "Path to an archive file to display", 3);
                this.append(sb, "", 0);
                this.append(sb, "immediateUpdate (Default: true)", 2);
                this.append(sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "move".equals(this.goal)) {
            this.append(sb, "truezip:move", 0);
            this.append(sb, "Use this goal to move single file or multiple files(via FileSet) between archives or directories", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "A single FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "Path of original file", 3);
                this.append(sb, "", 0);
                this.append(sb, "immediateUpdate (Default: true)", 2);
                this.append(sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "to", 2);
                this.append(sb, "Path of destination file", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose mode", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "remove".equals(this.goal)) {
            this.append(sb, "truezip:remove", 0);
            this.append(sb, "Remove a set of files from an existing archive", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "A single FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "immediateUpdate (Default: true)", 2);
                this.append(sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose mode", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update".equals(this.goal)) {
            this.append(sb, "truezip:update", 0);
            this.append(sb, "Update open archives immediately, flush cached data to disk.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "immediateUpdate (Default: true)", 2);
                this.append(sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

