/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Embedded;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.tomcat.AbstractI18NMojo;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractRunMojo
extends AbstractI18NMojo {
    private String packaging;
    private File configurationDir;
    private int port;
    private Map<String, String> systemProperties;
    private File additionalConfigFilesDir;
    private File serverXml;
    private File tomcatWebXml;
    private Embedded container;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isWar()) {
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.nonWar"));
            return;
        }
        try {
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.runningWar", this.getWebappUrl()));
            this.initConfiguration();
            this.startContainer();
            this.waitIndefinitely();
        }
        catch (LifecycleException exception) {
            throw new MojoExecutionException(this.getMessage("AbstractRunMojo.cannotStart"), (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.getMessage("AbstractRunMojo.cannotCreateConfiguration"), (Exception)exception);
        }
    }

    protected String getPath() {
        return this.path;
    }

    protected Context createContext(Embedded container) throws IOException {
        Context context = container.createContext(this.getPath(), this.getDocBase().getAbsolutePath());
        context.setLoader((Loader)this.createWebappLoader());
        context.setConfigFile(this.getContextFile().getAbsolutePath());
        return context;
    }

    protected WebappLoader createWebappLoader() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new WebappLoader(classLoader);
    }

    protected abstract File getDocBase();

    protected abstract File getContextFile();

    protected boolean isWar() {
        return "war".equals(this.packaging);
    }

    private URL getWebappUrl() throws MalformedURLException {
        return new URL("http", "localhost", this.port, this.getPath());
    }

    private void initConfiguration() throws IOException, MojoExecutionException {
        if (this.configurationDir.exists()) {
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.usingConfiguration", this.configurationDir));
        } else {
            this.getLog().info((CharSequence)this.getMessage("AbstractRunMojo.creatingConfiguration", this.configurationDir));
            this.configurationDir.mkdirs();
            File confDir = new File(this.configurationDir, "conf");
            confDir.mkdir();
            this.copyFile("/conf/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
            if (this.tomcatWebXml != null) {
                if (!this.tomcatWebXml.exists()) {
                    throw new MojoExecutionException(" tomcatWebXml " + this.tomcatWebXml.getPath() + " not exists");
                }
                this.copyFile(this.tomcatWebXml.getPath(), new File(confDir, "web.xml"));
            } else {
                this.copyFile("/conf/web.xml", new File(confDir, "web.xml"));
            }
            File logDir = new File(this.configurationDir, "logs");
            logDir.mkdir();
            File webappsDir = new File(this.configurationDir, "webapps");
            webappsDir.mkdir();
            if (this.additionalConfigFilesDir != null && this.additionalConfigFilesDir.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.addDefaultExcludes();
                scanner.setBasedir(this.additionalConfigFilesDir.getPath());
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                if (files != null && files.length > 0) {
                    this.getLog().info((CharSequence)"Coping additional tomcat config files");
                    for (int i = 0; i < files.length; ++i) {
                        File file = new File(this.additionalConfigFilesDir, files[i]);
                        this.getLog().info((CharSequence)(" copy " + file.getName()));
                        FileUtils.copyFileToDirectory((File)file, (File)confDir);
                    }
                }
            }
        }
    }

    private void copyFile(String fromPath, File toFile) throws IOException {
        URL fromURL = ((Object)((Object)this)).getClass().getResource(fromPath);
        if (fromURL == null) {
            throw new FileNotFoundException(fromPath);
        }
        FileUtils.copyURLToFile((URL)fromURL, (File)toFile);
    }

    private void startContainer() throws IOException, LifecycleException, MojoExecutionException {
        if (this.serverXml != null) {
            if (!this.serverXml.exists()) {
                throw new MojoExecutionException(this.serverXml.getPath() + " not exists");
            }
            this.container = new Catalina();
            this.container.setCatalinaHome(this.configurationDir.getAbsolutePath());
            ((Catalina)this.container).setConfigFile(this.serverXml.getPath());
            this.container.start();
        } else {
            this.container = new Embedded();
            this.container.setCatalinaHome(this.configurationDir.getAbsolutePath());
            this.container.setRealm((Realm)new MemoryRealm());
            Context context = this.createContext(this.container);
            String appBase = new File(this.configurationDir, "webapps").getAbsolutePath();
            Host host = this.container.createHost("localHost", appBase);
            host.addChild((Container)context);
            Engine engine = this.container.createEngine();
            engine.setName("localEngine");
            engine.addChild((Container)host);
            engine.setDefaultHost(host.getName());
            this.container.addEngine(engine);
            Connector httpConnector = this.container.createConnector((InetAddress)null, this.port, false);
            this.container.addConnector(httpConnector);
        }
        this.setupSystemPropteries();
        this.container.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AbstractRunMojo.this.stopContainer();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                this.getLog().warn((CharSequence)this.getMessage("AbstractRunMojo.interrupted"), (Throwable)exception);
            }
        }
    }

    private void stopContainer() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (LifecycleException exception) {
            this.getLog().warn((CharSequence)this.getMessage("AbstractRunMojo.cannotStop"), (Throwable)exception);
        }
    }

    private void setupSystemPropteries() {
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            this.getLog().info((CharSequence)"setting SystemProperties:");
            for (String key : this.systemProperties.keySet()) {
                String value = this.systemProperties.get(key);
                if (value != null) {
                    this.getLog().info((CharSequence)(" " + key + "=" + value));
                    System.setProperty(key, value);
                    continue;
                }
                this.getLog().info((CharSequence)("skip sysProps " + key + " with empty value"));
            }
        }
    }
}

