/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.mojo.tidy.task.Format;
import org.codehaus.mojo.tidy.task.TidyTask;
import org.codehaus.mojo.tidy.task.XMLEventReaderFactory;
import org.codehaus.plexus.util.StringUtils;

class EnsureOrderAndIndent
implements TidyTask {
    private static final List<SectionSorter> SECTION_SORTERS = Arrays.asList(new SectionSorter("/project", new NodeGroup("modelVersion"), new NodeGroup("parent"), new NodeGroup("groupId", "artifactId", "version", "packaging"), new NodeGroup("name", "description", "url", "inceptionYear", "organization", "licenses"), new NodeGroup("developers", "contributors"), new NodeGroup("mailingLists"), new NodeGroup("prerequisites"), new NodeGroup("modules"), new NodeGroup("scm", "issueManagement", "ciManagement", "distributionManagement"), new NodeGroup("properties"), new NodeGroup("dependencyManagement", "dependencies"), new NodeGroup("repositories", "pluginRepositories"), new NodeGroup("build"), new NodeGroup("reporting"), new NodeGroup("profiles")), new SectionSorter("/project/build", new NodeGroup("defaultGoal", "sourceDirectory", "scriptSourceDirectory", "testSourceDirectory", "directory", "outputDirectory", "testOutputDirectory", "finalName", "filters", "resources", "testResources", "pluginManagement", "plugins", "extensions")), new SectionSorter("dependency", new NodeGroup("groupId", "artifactId", "version", "type", "classifier", "scope", "systemPath", "exclusions", "optional")), new SectionSorter("dependency/exclusions/exclusion", new NodeGroup("groupId", "artifactId")), new SectionSorter("build/extensions/extension", new NodeGroup("groupId", "artifactId", "version")), new SectionSorter("/project/parent", new NodeGroup("groupId", "artifactId", "version", "relativePath")), new SectionSorter("plugin", new NodeGroup("groupId", "artifactId", "version")), new SectionSorter("/project/distributionManagement/relocation", new NodeGroup("groupId", "artifactId", "version")));

    EnsureOrderAndIndent() {
    }

    @Override
    public String tidyPom(String pom, Format format) throws XMLStreamException {
        for (SectionSorter sorter : SECTION_SORTERS) {
            pom = sorter.sortSections(pom, format);
        }
        return pom;
    }

    private static class SectionSorter {
        final String scope;
        final NodeGroup[] groups;
        final List<String> sequence;

        SectionSorter(String scope, NodeGroup ... groups) {
            this.scope = scope;
            this.groups = groups;
            this.sequence = this.calculateSequence(groups);
        }

        List<String> calculateSequence(NodeGroup[] groups) {
            ArrayList<String> sequence = new ArrayList<String>();
            for (NodeGroup group : groups) {
                sequence.addAll(group.nodes);
            }
            return sequence;
        }

        String sortSections(String pom, Format format) throws XMLStreamException {
            XMLEventReader reader = XMLEventReaderFactory.createEventReaderForPom(pom);
            String path = "";
            int posFirstUnformatted = 0;
            StringBuilder tidyPom = new StringBuilder();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    if (!this.isStartElementOfScope(path = path + "/" + event.asStartElement().getName().getLocalPart())) continue;
                    int pos = this.getPosOfNextEvent(reader);
                    tidyPom.append(pom.substring(posFirstUnformatted, pos));
                    tidyPom.append(this.formatSection(reader, pom, format));
                    posFirstUnformatted = this.getPosOfNextEvent(reader);
                    continue;
                }
                if (!event.isEndElement()) continue;
                path = this.substringBeforeLast(path, "/");
            }
            tidyPom.append(pom.substring(posFirstUnformatted));
            return tidyPom.toString();
        }

        private boolean isStartElementOfScope(String path) {
            if (this.scope.startsWith("/")) {
                return path.equals(this.scope);
            }
            return path.endsWith("/" + this.scope);
        }

        private String formatSection(XMLEventReader reader, String pom, Format format) throws XMLStreamException {
            int startOfSection = this.getPosOfNextEvent(reader);
            int[] starts = new int[this.sequence.size()];
            int[] ends = new int[this.sequence.size()];
            XMLEvent endScope = this.calculateStartsAndEnds(reader, starts, ends);
            return this.formatSection(reader, pom, format, startOfSection, starts, ends, endScope);
        }

        private XMLEvent calculateStartsAndEnds(XMLEventReader reader, int[] starts, int[] ends) throws XMLStreamException {
            Arrays.fill(starts, Integer.MAX_VALUE);
            Arrays.fill(ends, -1);
            int level = 0;
            while (reader.hasNext()) {
                int i;
                QName name;
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    if (++level != 1 || !this.hasToBeSorted(name = event.asStartElement().getName())) continue;
                    i = this.getSequenceIndex(name);
                    starts[i] = event.getLocation().getCharacterOffset();
                    continue;
                }
                if (!event.isEndElement()) continue;
                if (level == 0) {
                    return event;
                }
                if (level == 1 && this.hasToBeSorted(name = event.asEndElement().getName())) {
                    i = this.getSequenceIndex(name);
                    ends[i] = this.getPosOfNextEvent(reader);
                }
                --level;
            }
            throw new RuntimeException("End element missing.");
        }

        private boolean hasToBeSorted(QName nodeName) {
            String name = nodeName.getLocalPart();
            return this.sequence.contains(name);
        }

        private int getSequenceIndex(QName nodeName) {
            String name = nodeName.getLocalPart();
            if (this.sequence.contains(name)) {
                return this.sequence.indexOf(name);
            }
            throw new IllegalArgumentException("The path '" + nodeName + " does not specify an element of the sequence " + this.sequence + ".");
        }

        private String formatSection(XMLEventReader reader, String pom, Format format, int startOfSection, int[] starts, int[] ends, XMLEvent endScope) throws XMLStreamException {
            String outdent = this.calculateOutdent(pom, endScope);
            String indent = this.calculateIndent(pom, starts);
            int first = this.calculateFirst(starts, pom);
            StringBuilder output = new StringBuilder();
            output.append(pom.substring(startOfSection, first).trim());
            int i = 0;
            boolean firstGroupStarted = false;
            for (NodeGroup group : this.groups) {
                boolean groupStarted = false;
                for (String node : group.nodes) {
                    if (starts[i] != Integer.MAX_VALUE) {
                        if (firstGroupStarted && !groupStarted) {
                            output.append(format.getLineSeparator());
                        }
                        this.addTextIfNotEmpty(output, indent, this.getPrecedingText(pom, starts[i], ends), format);
                        this.addTextIfNotEmpty(output, indent, pom.substring(starts[i], ends[i]), format);
                        firstGroupStarted = true;
                        groupStarted = true;
                    }
                    ++i;
                }
            }
            int last = this.calculateLast(ends);
            int afterSection = this.getPosOfNextEvent(reader);
            int offsetEndElement = endScope.getLocation().getCharacterOffset();
            this.addTextIfNotEmpty(output, indent, pom.substring(last, offsetEndElement), format);
            this.addTextIfNotEmpty(output, outdent, pom.substring(offsetEndElement, afterSection), format);
            return output.toString();
        }

        private String calculateOutdent(String pom, XMLEvent endScope) {
            String before = pom.substring(0, endScope.getLocation().getCharacterOffset());
            return this.substringAfterLast(before, "\n");
        }

        private int calculateFirst(int[] starts, String pom) {
            int first = pom.length();
            for (int start : starts) {
                first = Math.min(first, start);
            }
            return first;
        }

        private int calculateLast(int[] ends) {
            int last = 0;
            for (int end : ends) {
                last = Math.max(last, end);
            }
            return last;
        }

        private String calculateIndent(String input, int[] starts) {
            int numNodesWithSpaceIndent = 0;
            int numNodesWithTabIndent = 0;
            int spaceIndentTotal = 0;
            int tabIndentTotal = 0;
            for (int start : starts) {
                String indent;
                if (start == Integer.MAX_VALUE || (indent = this.calculateIndent(input, start)).isEmpty()) continue;
                int numTabs = StringUtils.countMatches((String)indent, (String)"\t");
                if (numTabs == indent.length()) {
                    ++numNodesWithTabIndent;
                    tabIndentTotal += numTabs;
                    continue;
                }
                if (indent.contains("\t")) continue;
                ++numNodesWithSpaceIndent;
                spaceIndentTotal += indent.length();
            }
            if (numNodesWithSpaceIndent == 0 && numNodesWithTabIndent == 0) {
                return "  ";
            }
            if (numNodesWithSpaceIndent > numNodesWithTabIndent) {
                int averageIndent = spaceIndentTotal / numNodesWithSpaceIndent;
                return StringUtils.repeat((String)" ", (int)averageIndent);
            }
            int averageIndent = tabIndentTotal / numNodesWithTabIndent;
            return StringUtils.repeat((String)"\t", (int)averageIndent);
        }

        private String calculateIndent(String input, int startOfTag) {
            for (int i = startOfTag; i > 1; --i) {
                String character = input.substring(i - 1, i);
                if (StringUtils.isWhitespace((String)character) && !"\n".equals(character) && !"\r".equals(character)) continue;
                return input.substring(i, startOfTag);
            }
            return input;
        }

        private String getPrecedingText(String pom, int start, int[] ends) {
            int startPrecedingText = -1;
            for (int end : ends) {
                if (end >= start) continue;
                startPrecedingText = Math.max(startPrecedingText, end);
            }
            if (startPrecedingText != -1) {
                return pom.substring(startPrecedingText, start);
            }
            return "";
        }

        private void addTextIfNotEmpty(StringBuilder output, String indent, String text, Format format) {
            String trimmedText = text.trim();
            if (trimmedText.length() != 0) {
                output.append(format.getLineSeparator());
                output.append(indent);
                output.append(trimmedText);
            }
        }

        private int getPosOfNextEvent(XMLEventReader reader) throws XMLStreamException {
            return reader.peek().getLocation().getCharacterOffset();
        }

        private String substringBeforeLast(String str, String separator) {
            int endIndex = str.lastIndexOf(separator);
            return str.substring(0, endIndex);
        }

        private String substringAfterLast(String str, String separator) {
            int beginIndex = str.lastIndexOf(separator) + 1;
            return str.substring(beginIndex);
        }
    }

    private static class NodeGroup {
        final List<String> nodes;

        NodeGroup(String ... nodes) {
            this.nodes = Arrays.asList(nodes);
        }
    }
}

