/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.codehaus.mojo.sonar.MavenPluginManagerHelper;
import org.codehaus.mojo.sonar.ServerMetadata;
import org.codehaus.mojo.sonar.bootstrap.InternalMojoBootstraper;
import org.codehaus.mojo.sonar.bootstrap.RunnerBootstraper;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="sonar", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST)
public class SonarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="sonar.host.url", defaultValue="http://localhost:9000", alias="sonar.host.url")
    private String sonarHostURL;
    @Parameter(property="sonar.skip", defaultValue="false", alias="sonar.skip")
    private boolean skip;
    @Component
    protected MavenPluginManager mavenPluginManager;
    @Component
    protected MavenPluginManagerHelper mavenPluginManagerHelper;
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector artifactCollector;
    @Component
    private DependencyTreeBuilder dependencyTreeBuilder;
    @Component
    private MavenProjectBuilder projectBuilder;
    @Component(role=SecDispatcher.class)
    private SecDispatcher securityDispatcher;
    @Component
    private RuntimeInformation runtimeInformation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"sonar.skip = true: Skipping analysis");
            return;
        }
        try {
            ServerMetadata server = new ServerMetadata(this.sonarHostURL);
            server.logSettings(this.getLog());
            if (server.supportsSonarQubeRunnerBootstrappingFromMaven()) {
                new RunnerBootstraper(this.runtimeInformation, this.getLog(), this.session, this.lifecycleExecutor, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder, this.projectBuilder, this.securityDispatcher, server).execute();
            } else {
                new InternalMojoBootstraper(server, this.mavenPluginManager, this.mavenPluginManagerHelper).start(this.project, this.session);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute SonarQube analysis", (Exception)e);
        }
    }

    @VisibleForTesting
    void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    @VisibleForTesting
    void setSonarHostURL(String sonarHostURL) {
        this.sonarHostURL = sonarHostURL;
    }
}

