/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ServerMetadata {
    public static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private String url;
    private String version;

    public ServerMetadata(String url) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public String getVersion() throws IOException {
        if (this.version == null) {
            this.version = this.remoteContent("/api/server/version");
        }
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public void logSettings(Log log) throws MojoExecutionException {
        try {
            log.info((CharSequence)("Sonar version: " + this.getVersion()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Sonar server can not be reached at " + this.url + ". Please check the parameter 'sonar.host.url'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String remoteContent(String path) throws IOException {
        String fullUrl = this.url + path;
        HttpURLConnection conn = ServerMetadata.getConnection(fullUrl + path, "GET");
        InputStreamReader reader = new InputStreamReader((InputStream)conn.getContent());
        try {
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("Status returned by url : '" + fullUrl + "' is invalid : " + statusCode);
            }
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            conn.disconnect();
        }
    }

    static HttpURLConnection getConnection(String url, String method) throws IOException {
        URL page = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.setRequestMethod(method);
        conn.connect();
        return conn;
    }

    protected boolean supportsMaven3() throws IOException {
        return !ServerMetadata.isVersionPriorTo2Dot4(this.getVersion());
    }

    protected static boolean isVersionPriorTo2Dot4(String version) {
        return version.startsWith("1.") || version.startsWith("2.0.") || version.equals("2.1") || version.equals("2.2") || version.startsWith("2.1.") || version.startsWith("2.3.") || version.equals("2.3");
    }
}

