/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.svn;

import java.io.File;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.codehaus.mojo.scmchangelog.scm.svn.SvnListConsumer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnListCommand
extends AbstractListCommand
implements SvnCommand {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private Pattern filter;

    public SvnListCommand(Pattern filter) {
        this.filter = filter;
    }

    protected ListScmResult executeListCommand(ScmProviderRepository repository, ScmFileSet fileSet, boolean recursive, ScmVersion version) throws ScmException {
        int exitCode;
        this.getLogger().info("Executing our command " + version);
        Commandline cl = SvnListCommand.createCommandLine((SvnScmProviderRepository)repository, fileSet, recursive, version);
        SvnListConsumer consumer = new SvnListConsumer(this.filter);
        consumer.setLogger(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword((Commandline)cl));
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        this.getLogger().info("Executing this command " + cl.toString());
        try {
            exitCode = SvnCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        }
        catch (CommandLineException ex) {
            this.getLogger().error("Error while executing command.", (Throwable)ex);
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new ListScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new ListScmResult(cl.toString(), consumer.analyse());
    }

    static Commandline createCommandLine(SvnScmProviderRepository repository, ScmFileSet fileSet, boolean recursive, ScmVersion version) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine((File)TMP_DIR, (SvnScmProviderRepository)repository);
        cl.createArgument().setValue("list");
        if (recursive) {
            cl.createArgument().setValue("--recursive");
        }
        cl.createArgument().setValue("--xml");
        if (version != null && StringUtils.isNotEmpty((String)version.getName()) && version instanceof ScmRevision) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(version.getName());
        }
        String baseUrl = version instanceof ScmTag ? repository.getTagBase() : (version instanceof ScmBranch ? repository.getBranchBase() : repository.getUrl());
        Iterator it = fileSet.getFileList().iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            cl.createArgument().setValue(baseUrl + "/" + file.getPath().replace('\\', '/'));
        }
        return cl;
    }
}

