/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.minijar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.minijar.AbstractPluginMojo;
import org.codehaus.mojo.minijar.resource.ComponentsXmlHandler;
import org.codehaus.mojo.minijar.resource.LicenseHandler;
import org.vafer.dependency.Clazz;
import org.vafer.dependency.Console;
import org.vafer.dependency.resources.ResourceHandler;
import org.vafer.dependency.resources.Version;
import org.vafer.dependency.utils.Jar;
import org.vafer.dependency.utils.JarUtils;

public final class UeberJarMojo
extends AbstractPluginMojo {
    private MavenProjectHelper projectHelper;
    protected String name;
    private boolean includeArtifact;
    private boolean replaceArtifact;
    private final ResourceHandler[] handlers = new ResourceHandler[]{new LicenseHandler(), new ComponentsXmlHandler()};

    private InputStream handle(Jar jar, String oldName, String newName, Version[] versions, InputStream inputStream) throws IOException {
        InputStream is = inputStream;
        for (int i = 0; i < this.handlers.length; ++i) {
            if (is == null) {
                return null;
            }
            is = this.handlers[i].onResource(jar, oldName, newName, versions, is);
        }
        return is;
    }

    public void execute(final Set pRemovable, Set pDependencies, Set pRelocateDependencies) throws MojoExecutionException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>(pDependencies);
        Artifact projectArtifact = this.getProject().getArtifact();
        if (this.includeArtifact) {
            this.getLog().info((CharSequence)"Including project artifact.");
            artifacts.add(projectArtifact);
        }
        Jar[] jars = new Jar[artifacts.size()];
        Iterator it = artifacts.iterator();
        for (int i = 0; i < jars.length; ++i) {
            Artifact artifact = (Artifact)it.next();
            File file = artifact.getFile();
            try {
                Jar jar;
                jars[i] = jar = new Jar(file, artifact != projectArtifact);
                continue;
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Could not locate jar " + file, (Exception)e);
            }
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("artifactId", projectArtifact.getArtifactId());
        variables.put("groupId", projectArtifact.getGroupId());
        variables.put("version", projectArtifact.getVersion());
        String newName = this.replaceVariables(variables, this.name);
        File outputJar = new File(this.buildDirectory, newName);
        try {
            JarUtils.processJars((Jar[])jars, (ResourceHandler)new ResourceHandler(){

                public void onStartProcessing(JarOutputStream pOutput) throws IOException {
                    for (int i = 0; i < UeberJarMojo.this.handlers.length; ++i) {
                        UeberJarMojo.this.handlers[i].onStartProcessing(pOutput);
                    }
                }

                public void onStartJar(Jar jar, JarOutputStream pOutput) throws IOException {
                    for (int i = 0; i < UeberJarMojo.this.handlers.length; ++i) {
                        UeberJarMojo.this.handlers[i].onStartJar(jar, pOutput);
                    }
                }

                public InputStream onResource(Jar jar, String oldName, String newName, Version[] versions, InputStream inputStream) throws IOException {
                    if (jar != versions[0].getJar()) {
                        return null;
                    }
                    if (!oldName.endsWith(".class")) {
                        return UeberJarMojo.this.handle(jar, oldName, newName, versions, inputStream);
                    }
                    String clazzName = oldName.replace('/', '.').substring(0, oldName.length() - ".class".length());
                    if (pRemovable.contains(new Clazz(clazzName))) {
                        if (UeberJarMojo.this.isInKeepUnusedClasses(UeberJarMojo.this.name)) {
                            return UeberJarMojo.this.handle(jar, oldName, newName, versions, inputStream);
                        }
                        return null;
                    }
                    return UeberJarMojo.this.handle(jar, oldName, newName, versions, inputStream);
                }

                public void onStopJar(Jar pJar, JarOutputStream pOutput) throws IOException {
                    for (int i = 0; i < UeberJarMojo.this.handlers.length; ++i) {
                        UeberJarMojo.this.handlers[i].onStopJar(pJar, pOutput);
                    }
                }

                public void onStopProcessing(JarOutputStream pOutput) throws IOException {
                    for (int i = 0; i < UeberJarMojo.this.handlers.length; ++i) {
                        UeberJarMojo.this.handlers[i].onStopProcessing(pOutput);
                    }
                }
            }, (FileOutputStream)new FileOutputStream(outputJar), (Console)new Console(){

                public void println(String pString) {
                    UeberJarMojo.this.getLog().debug((CharSequence)pString);
                }
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create combined output jar " + outputJar, e);
        }
        if (this.replaceArtifact) {
            this.getLog().info((CharSequence)"Replacing artifact.");
            outputJar.renameTo(projectArtifact.getFile());
        } else {
            this.getLog().info((CharSequence)"Attaching artifact.");
            this.projectHelper.attachArtifact(this.getProject(), "jar", "ueber", outputJar);
        }
    }
}

