/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.minijar;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.vafer.dependency.Clazzpath;
import org.vafer.dependency.ClazzpathUnit;

public abstract class AbstractPluginMojo
extends AbstractMojo {
    private MavenProject project;
    protected File buildDirectory;
    protected HashSet includeDependenciesInRelocation = null;
    protected HashSet excludeDependenciesInRelocation = null;
    protected HashSet includeDependencies = null;
    protected HashSet excludeDependencies = null;
    protected boolean stripUnusedClasses;
    protected HashSet keepUnusedClassesFromArtifacts = new HashSet();
    protected HashSet keepUnusedClasses = new HashSet();

    protected MavenProject getProject() {
        if (this.project.getExecutionProject() != null) {
            return this.project.getExecutionProject();
        }
        return this.project;
    }

    protected String replaceVariables(Map pVariables, String pExpression) {
        char[] s = pExpression.toCharArray();
        char[] open = "[".toCharArray();
        char[] close = "]".toCharArray();
        StringBuffer out = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        char[] watch = open;
        int w = 0;
        for (int i = 0; i < s.length; ++i) {
            char c = s[i];
            if (c == watch[w]) {
                if (watch.length != ++w) continue;
                if (watch == open) {
                    out.append(sb);
                    sb = new StringBuffer();
                    watch = close;
                } else if (watch == close) {
                    String variable = (String)pVariables.get(sb.toString());
                    if (variable != null) {
                        out.append(variable);
                    } else {
                        this.getLog().error((CharSequence)("Unknown variable " + sb));
                    }
                    sb = new StringBuffer();
                    watch = open;
                }
                w = 0;
                continue;
            }
            if (w > 0) {
                sb.append(watch, 0, w);
            }
            sb.append(c);
            w = 0;
        }
        if (watch == open) {
            out.append(sb);
        }
        return out.toString();
    }

    public boolean isInKeepUnusedClassesFromArtifacts(Artifact artifact) {
        String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
        return this.keepUnusedClassesFromArtifacts.contains(id);
    }

    public boolean isInKeepUnusedClasses(String clazzname) {
        return this.keepUnusedClasses.contains(clazzname);
    }

    private Set getArtifactsFromIds(Set artifacts, Set ids) {
        if (ids == null) {
            return null;
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            String id = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (!ids.contains(id)) continue;
            result.add(artifact);
        }
        return result;
    }

    private Set combine(Set all, Set included, Set excluded, Set defaults) {
        HashSet result = new HashSet();
        if (excluded != null) {
            result.addAll(all);
            result.removeAll(excluded);
        }
        if (included != null) {
            result.addAll(included);
        }
        if (excluded == null && included == null) {
            result.addAll(defaults);
        }
        return result;
    }

    public abstract void execute(Set var1, Set var2, Set var3) throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        HashSet removable = new HashSet();
        if (this.excludeDependencies != null && this.excludeDependencies.size() == 0) {
            this.excludeDependencies = null;
        }
        if (this.includeDependencies != null && this.includeDependencies.size() == 0) {
            this.includeDependencies = null;
        }
        if (this.excludeDependenciesInRelocation != null && this.excludeDependenciesInRelocation.size() == 0) {
            this.excludeDependenciesInRelocation = null;
        }
        if (this.includeDependenciesInRelocation != null && this.includeDependenciesInRelocation.size() == 0) {
            this.includeDependenciesInRelocation = null;
        }
        if (this.excludeDependencies != null && this.includeDependencies != null) {
            throw new MojoExecutionException("Both parameters excludeDependencies and includeDependencies are mutual exclusive");
        }
        if (this.excludeDependenciesInRelocation != null && this.includeDependenciesInRelocation != null) {
            throw new MojoExecutionException("Both parameters excludeDependenciesInRelocation and includeDependenciesInRelocation are mutual exclusive");
        }
        Set projectArtifacts = this.getProject().getArtifacts();
        Set dependencies = this.combine(projectArtifacts, this.getArtifactsFromIds(projectArtifacts, this.includeDependencies), this.getArtifactsFromIds(projectArtifacts, this.excludeDependencies), projectArtifacts);
        Set relocateDependencies = this.combine(projectArtifacts, this.getArtifactsFromIds(projectArtifacts, this.includeDependenciesInRelocation), this.getArtifactsFromIds(projectArtifacts, this.excludeDependenciesInRelocation), projectArtifacts);
        this.getLog().debug((CharSequence)("dependencies: " + dependencies));
        this.getLog().debug((CharSequence)("relocateDependencies: " + relocateDependencies));
        if (this.stripUnusedClasses) {
            this.getLog().info((CharSequence)"Calculating transitive hull of class dependencies.");
            try {
                Artifact projectArtifact = this.getProject().getArtifact();
                if (projectArtifact == null) {
                    throw new MojoExecutionException("No project artifact");
                }
                File projectArtifactFile = projectArtifact.getFile();
                if (projectArtifactFile == null) {
                    throw new MojoExecutionException("No project artifact file");
                }
                Clazzpath clazzpath = new Clazzpath();
                ClazzpathUnit jar = new ClazzpathUnit(clazzpath, projectArtifactFile.getAbsolutePath());
                Iterator i = this.project.getArtifacts().iterator();
                while (i.hasNext()) {
                    Artifact dependency = (Artifact)i.next();
                    if (!dependencies.contains(dependency)) {
                        this.getLog().info((CharSequence)("Ignoring " + dependency));
                        continue;
                    }
                    new ClazzpathUnit(clazzpath, dependency.getFile().getAbsolutePath());
                }
                removable.addAll(clazzpath.getClazzes());
                int total = removable.size();
                removable.removeAll(jar.getClazzes());
                removable.removeAll(jar.getTransitiveDependencies());
                this.getLog().info((CharSequence)("Can remove " + removable.size() + " of " + total + " classes (" + 100 * removable.size() / total + "%)."));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not analyse classpath dependencies", (Exception)e);
            }
        }
        this.execute(removable, dependencies, relocateDependencies);
    }
}

