/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.AbstractDownloadLicensesMojo;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.download.LicensedArtifact;
import org.codehaus.mojo.license.utils.MojoHelper;

@Mojo(name="aggregate-download-licenses", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE, aggregator=true)
public class AggregateDownloadLicensesMojo
extends AbstractDownloadLicensesMojo {
    @Parameter(property="license.skipAggregateDownloadLicenses", defaultValue="false")
    private boolean skipAggregateDownloadLicenses;
    @Parameter(property="license.executeOnlyOnRootModule", alias="aggregateDownloadLicenses.executeOnlyOnRootModule", defaultValue="true")
    private boolean executeOnlyOnRootModule;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="license.extendedInfo", defaultValue="false")
    private boolean extendedInfo;

    @Override
    protected boolean isSkip() {
        return this.skipAggregateDownloadLicenses || this.executeOnlyOnRootModule && !this.getProject().isExecutionRoot();
    }

    @Override
    protected Map<String, LicensedArtifact> getDependencies() {
        TreeMap<String, LicensedArtifact> result = new TreeMap<String, LicensedArtifact>();
        for (MavenProject p : this.reactorProjects) {
            this.licensedArtifactResolver.loadProjectDependencies(new ResolvedProjectDependencies(p.getArtifacts(), MojoHelper.getDependencyArtifacts(p)), this, this.remoteRepositories, result, this.extendedInfo, this.licenseMerges);
        }
        return result;
    }
}

