/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCollector {
    private BuildContext buildContext;
    private final String[] defaultIncludes;
    private final String[] defaultExcludes;

    FileCollector(BuildContext buildContext, String[] defaultIncludes, String[] defaultExcludes) {
        this.buildContext = buildContext;
        this.defaultIncludes = defaultIncludes;
        this.defaultExcludes = defaultExcludes;
    }

    public List<String> collectPaths(File sourceFolder, List<String> includes, List<String> excludes) {
        Scanner scanner = this.buildContext.newScanner(sourceFolder, true);
        String[] includesArray = this.getPatternsOrDefault(includes, this.defaultIncludes);
        scanner.setIncludes(includesArray);
        String[] excludesArray = this.getPatternsOrDefault(excludes, this.defaultExcludes);
        scanner.setExcludes(excludesArray);
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles());
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    private String[] getPatternsOrDefault(List<String> patterns, String[] defaultPatterns) {
        if (patterns == null || patterns.isEmpty()) {
            return defaultPatterns;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }
}

