/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc;

import com.thoughtworks.qdox.model.DocletTag;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;

public class JavaDocData {
    public static final String NO_COMMENT = "";
    private String comment;
    private SortedMap<String, String> tag2ValueMap;

    public JavaDocData(String comment, List<DocletTag> tags) {
        this.comment = comment == null ? NO_COMMENT : comment;
        this.tag2ValueMap = new TreeMap<String, String>();
        for (DocletTag current : tags) {
            String tagName = current.getName();
            String tagValue = current.getValue();
            String currentValue = (String)this.tag2ValueMap.get(tagName);
            if (currentValue != null) {
                tagValue = currentValue + ", " + current.getValue();
            }
            this.tag2ValueMap.put(tagName, tagValue);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public SortedMap<String, String> getTag2ValueMap() {
        return this.tag2ValueMap;
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("\n+=================\n");
        toReturn.append("| Comment: ").append(this.comment).append("\n");
        if (this.tag2ValueMap.size() == 0) {
            toReturn.append("| No JavaDoc tags.\n");
        } else {
            toReturn.append("| ").append(this.tag2ValueMap.size()).append(" JavaDoc tags ...\n");
            for (Map.Entry<String, String> current : this.tag2ValueMap.entrySet()) {
                toReturn.append("| ").append(current.getKey()).append(": ").append(current.getValue()).append("\n");
            }
        }
        toReturn.append("+=================\n\n");
        return toReturn.toString().replace("\n", AbstractJaxbMojo.NEWLINE);
    }
}

