/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.cobertura.AbstractCoberturaMojo;
import org.codehaus.mojo.cobertura.configuration.ConfigInstrumentation;
import org.codehaus.mojo.cobertura.tasks.InstrumentTask;
import org.codehaus.plexus.util.FileUtils;

public class CoberturaInstrumentMojo
extends AbstractCoberturaMojo {
    private ArtifactFactory factory;

    public void execute() throws MojoExecutionException {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().info((CharSequence)"Not executing cobertura:instrument as the project is not a Java classpath-capable package");
        } else {
            File outputDirectory;
            File instrumentedDirectory = new File(this.project.getBuild().getDirectory(), "generated-classes/cobertura");
            if (!instrumentedDirectory.exists()) {
                instrumentedDirectory.mkdirs();
            }
            if (this.instrumentation == null) {
                this.instrumentation = new ConfigInstrumentation();
            }
            if (this.instrumentation.getIncludes().isEmpty()) {
                this.instrumentation.addInclude("**/*.class");
            }
            if (!(outputDirectory = new File(this.project.getBuild().getOutputDirectory())).exists()) {
                outputDirectory.mkdirs();
            }
            try {
                FileUtils.copyDirectoryStructure((File)outputDirectory, (File)instrumentedDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to prepare instrumentation directory.", (Exception)e);
            }
            this.instrumentation.setBasedir(instrumentedDirectory);
            InstrumentTask task = new InstrumentTask();
            this.setTaskDefaults(task);
            task.setConfig(this.instrumentation);
            task.setDestinationDir(instrumentedDirectory);
            task.setDataFile(this.dataFile);
            task.execute();
            this.addCoberturaDependenciesToTestClasspath();
            System.setProperty("net.sourceforge.cobertura.datafile", this.dataFile.getPath());
            this.project.getBuild().setOutputDirectory(instrumentedDirectory.getPath());
            System.setProperty("project.build.outputDirectory", instrumentedDirectory.getPath());
        }
    }

    private void addCoberturaDependenciesToTestClasspath() throws MojoExecutionException {
        Map pluginArtifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.pluginClasspathList);
        Artifact coberturaArtifact = (Artifact)pluginArtifactMap.get("cobertura:cobertura-runtime");
        if (coberturaArtifact == null) {
            throw new MojoExecutionException("Couldn't find 'cobertura' artifact in plugin dependencies");
        }
        coberturaArtifact = this.artifactScopeToTest(coberturaArtifact);
        if (this.project.getDependencyArtifacts() != null) {
            HashSet<Artifact> set = new HashSet<Artifact>(this.project.getDependencyArtifacts());
            set.add(coberturaArtifact);
            this.project.setDependencyArtifacts(set);
        }
    }

    private Artifact artifactScopeToTest(Artifact artifact) {
        return this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "test", artifact.getType());
    }
}

