/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.ReportGenerator;
import org.codehaus.mojo.chronos.report.Utils;
import org.codehaus.mojo.chronos.report.chart.ChartRendererImpl;
import org.codehaus.mojo.chronos.report.chart.ChartUtil;
import org.codehaus.mojo.chronos.report.chart.ChronosReportPlugin;
import org.codehaus.mojo.chronos.report.chart.GraphGenerator;
import org.xml.sax.SAXException;

public abstract class AbstractReportMojo
extends AbstractMavenReport {
    protected void generateReport(Locale locale) throws MavenReportException {
        try {
            TestDataDirectory testDataDirectory = this.getTestDataDirectory();
            GroupedResponsetimeSamples jmeterSamples = testDataDirectory.readResponsetimeSamples();
            if (jmeterSamples.size() == 0) {
                throw new MavenReportException("Response time samples not found for " + this.getDataId());
            }
            this.getLog().info((CharSequence)("  tests: " + jmeterSamples.getSampleGroups().size()));
            this.getLog().info((CharSequence)("  jmeter samples: " + jmeterSamples.size()));
            this.getLog().info((CharSequence)" generating charts...");
            GCSamples gcSamples = testDataDirectory.readGCSamples();
            List<ChronosReportPlugin> defaultPlugins = ChartUtil.createDefaultPlugins(jmeterSamples, gcSamples);
            GraphGenerator graphGenerator = new GraphGenerator(defaultPlugins, this.getLog());
            ChartRendererImpl renderer = new ChartRendererImpl(this.getOutputDirectory());
            graphGenerator.generateGraphs(renderer, this.getBundle(locale), this.getConfig());
            ReportGenerator reportGenerator = new ReportGenerator(this.getBundle(locale), this.getConfig(), graphGenerator);
            this.getLog().info((CharSequence)" generating report...");
            Sink sink = this.getSink();
            reportGenerator.doGenerateReport(sink, jmeterSamples);
        }
        catch (IOException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
        catch (SAXException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
    }

    protected abstract TestDataDirectory getTestDataDirectory();

    private ResourceBundle getBundle(Locale locale) {
        return Utils.getBundle(locale);
    }

    private ReportConfig getConfig() {
        return new ReportConfig(){

            public int getAverageduration() {
                return AbstractReportMojo.this.getReportAverageDuration();
            }

            public String getDescription() {
                return AbstractReportMojo.this.getReportDescription();
            }

            public double getHistoryChartUpperBound() {
                return AbstractReportMojo.this.getReportHistoryChartUpperBound();
            }

            public String getId() {
                return AbstractReportMojo.this.getId();
            }

            public String getMetadata() {
                return AbstractReportMojo.this.getMetadata();
            }

            public String getTitle() {
                return AbstractReportMojo.this.getReportTitle();
            }

            public boolean isShowaverage() {
                return AbstractReportMojo.this.isShowAverage();
            }

            public boolean isShowdetails() {
                return AbstractReportMojo.this.isShowDetails();
            }

            public boolean isShowgc() {
                return AbstractReportMojo.this.isShowGC();
            }

            public boolean isShowhistogram() {
                return AbstractReportMojo.this.isShowHistogram();
            }

            public boolean isShowinfotable() {
                return AbstractReportMojo.this.isShowInfotable();
            }

            public boolean isShowpercentile95() {
                return AbstractReportMojo.this.isShowPercentile95();
            }

            public boolean isShowpercentile99() {
                return AbstractReportMojo.this.isShowPercentile99();
            }

            public boolean isShowresponse() {
                return AbstractReportMojo.this.isShowResponse();
            }

            public boolean isShowServerlog() {
                return AbstractReportMojo.this.isShowServerLog();
            }

            public boolean isShowsummary() {
                return AbstractReportMojo.this.isShowSummary();
            }

            public boolean isShowsummarycharts() {
                return AbstractReportMojo.this.isShowsummaryCharts();
            }

            public boolean isShowthroughput() {
                return AbstractReportMojo.this.isShowThroughput();
            }

            public boolean isShowtimeinfo() {
                return AbstractReportMojo.this.isShowTimeinfo();
            }
        };
    }

    public String getOutputName() {
        return this.getConfig().getId();
    }

    protected abstract String getId();

    protected abstract String getDataId();

    protected abstract String getMetadata();

    protected abstract int getReportAverageDuration();

    protected abstract String getReportDescription();

    protected abstract double getReportHistoryChartUpperBound();

    protected abstract String getReportTitle();

    protected abstract boolean isShowAverage();

    protected abstract boolean isShowDetails();

    protected abstract boolean isShowGC();

    protected abstract boolean isShowHistogram();

    protected abstract boolean isShowInfotable();

    protected abstract boolean isShowPercentile95();

    protected abstract boolean isShowPercentile99();

    protected abstract boolean isShowResponse();

    protected abstract boolean isShowServerLog();

    protected abstract boolean isShowSummary();

    protected abstract boolean isShowsummaryCharts();

    protected abstract boolean isShowThroughput();

    protected abstract boolean isShowTimeinfo();
}

