/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jira;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

public final class JiraDownloader2 {
    private Log log;
    private File output;
    private int nbEntriesMax;
    private String filter;
    private String statusIds;
    private String resolutionIds;
    private String priorityIds;
    private String component;
    private String jiraUser;
    private String jiraPassword;
    private String webUser;
    private String webPassword;
    private MavenProject project;
    private Settings settings;
    private static Map statusMap = new HashMap();
    private static Map resolutionMap = new HashMap();
    private static Map priorityMap = new HashMap();

    private String createFilter() {
        int i;
        if (this.filter != null && this.filter.length() > 0) {
            if (this.filter.charAt(0) == '&') {
                return this.filter.substring(1);
            }
            return this.filter;
        }
        StringBuffer localFilter = new StringBuffer();
        if (this.statusIds != null) {
            String[] stats = this.statusIds.split(",");
            for (i = 0; i < stats.length; ++i) {
                String statusParam = (String)statusMap.get(stats[i]);
                if (statusParam == null) continue;
                localFilter.append("&statusIds=" + statusParam);
            }
        }
        if (this.priorityIds != null) {
            String[] prios = this.priorityIds.split(",");
            for (i = 0; i < prios.length; ++i) {
                String priorityParam = (String)priorityMap.get(prios[i]);
                if (priorityParam == null) continue;
                localFilter.append("&priorityIds=" + priorityParam);
            }
        }
        if (this.resolutionIds != null) {
            String[] resos = this.resolutionIds.split(",");
            for (i = 0; i < resos.length; ++i) {
                String resoParam = (String)resolutionMap.get(resos[i]);
                if (resoParam == null) continue;
                localFilter.append("&resolutionIds=" + resoParam);
            }
        }
        if (this.component != null) {
            String[] components = this.component.split(",");
            for (i = 0; i < components.length; ++i) {
                if (components[i].length() <= 0) continue;
                localFilter.append("&component=" + components[i]);
            }
        }
        String sort = "&sorter/field=created&sorter/order=DESC&sorter/field=priority&sorter/order=DESC";
        return localFilter + sort;
    }

    public void doExecute() throws Exception {
        try {
            HttpClient cl = new HttpClient();
            HttpState state = new HttpState();
            HostConfiguration hc = new HostConfiguration();
            cl.setHostConfiguration(hc);
            cl.setState(state);
            this.determineProxy(cl);
            Map urlMap = this.getJiraUrlAndIssueId();
            String jiraUrl = (String)urlMap.get("url");
            String jiraId = (String)urlMap.get("id");
            this.doAuthentication(cl, jiraUrl);
            String fullURL = jiraUrl + "/secure/IssueNavigator.jspa?view=rss&pid=" + jiraId;
            fullURL = fullURL + this.createFilter();
            fullURL = fullURL + "&tempMax=" + this.nbEntriesMax + "&reset=true&decorator=none";
            this.download(cl, fullURL);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error accessing " + this.project.getIssueManagement().getUrl()), (Throwable)e);
        }
    }

    private Map getJiraUrlAndIssueId() {
        String jiraUrl;
        HashMap<String, String> urlMap = new HashMap<String, String>();
        String url = this.project.getIssueManagement().getUrl();
        int pos = url.indexOf("?");
        String id = "";
        if (pos >= 0) {
            id = url.substring(url.lastIndexOf("=") + 1);
        }
        if ((jiraUrl = url.substring(0, url.lastIndexOf("/"))).endsWith("secure")) {
            jiraUrl = jiraUrl.substring(0, jiraUrl.lastIndexOf("/"));
        }
        this.getLog().info((CharSequence)("Jira lives at: " + jiraUrl));
        urlMap.put("url", jiraUrl);
        urlMap.put("id", id);
        return urlMap;
    }

    private void doAuthentication(HttpClient client, String jiraUrl) {
        if (this.webUser != null && this.webUser.length() > 0) {
            client.getState().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.webUser, this.webPassword);
            this.getLog().info((CharSequence)("Using username: " + this.webUser + " for Basic Authentication against the webserver at " + jiraUrl));
            client.getState().setCredentials(null, null, (Credentials)defaultcreds);
        }
        String loginUrl = null;
        if (this.jiraUser != null && this.jiraUser.length() > 0 && this.jiraPassword != null) {
            StringBuffer loginLink = new StringBuffer(jiraUrl);
            loginLink.append("/login.jsp?os_destination=/secure/");
            loginLink.append("&os_username=").append(this.jiraUser);
            this.getLog().info((CharSequence)("Login URL: " + loginLink + "&os_password=*******"));
            loginLink.append("&os_password=").append(this.jiraPassword);
            loginUrl = loginLink.toString();
        }
        if (loginUrl != null) {
            GetMethod loginGet = new GetMethod(loginUrl);
            try {
                client.executeMethod((HttpMethod)loginGet);
                this.getLog().info((CharSequence)"Succesfully logged in into JIRA.");
            }
            catch (Exception e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)"Error trying to login into JIRA:", (Throwable)e);
                }
                this.getLog().error((CharSequence)("Error trying to login into JIRA. Cause is: " + e.getLocalizedMessage()));
            }
        }
    }

    private void determineProxy(HttpClient client) {
        Proxy proxy = null;
        String proxyHost = null;
        int proxyPort = 0;
        String proxyUser = null;
        String proxyPass = null;
        if (this.project == null) {
            this.getLog().error((CharSequence)"No project set. No proxy info available.");
            return;
        }
        if (this.settings != null) {
            proxy = this.settings.getActiveProxy();
        }
        if (proxy != null) {
            proxyHost = this.settings.getActiveProxy().getHost();
            proxyPort = this.settings.getActiveProxy().getPort();
            proxyUser = this.settings.getActiveProxy().getUsername();
            proxyPass = this.settings.getActiveProxy().getPassword();
            this.getLog().info((CharSequence)proxyPass);
        }
        if (proxyHost != null) {
            client.getHostConfiguration().setProxy(proxyHost, proxyPort);
            this.getLog().info((CharSequence)("Using proxy: " + proxyHost + " at port " + proxyPort));
            if (proxyUser != null) {
                this.getLog().info((CharSequence)("Using proxy user: " + proxyUser));
                client.getState().setProxyCredentials(null, null, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
            }
        }
    }

    private void download(HttpClient cl, String link) {
        try {
            GetMethod gm = new GetMethod(link);
            this.getLog().info((CharSequence)("Downloading " + link));
            gm.setFollowRedirects(true);
            cl.executeMethod((HttpMethod)gm);
            String strGetResponseBody = gm.getResponseBodyAsString();
            PrintWriter pw = new PrintWriter(new FileWriter(this.output));
            pw.print(strGetResponseBody);
            pw.close();
            StatusLine sl = gm.getStatusLine();
            if (sl == null) {
                this.getLog().info((CharSequence)("Unknown error validating link : " + link));
                return;
            }
            if (gm.getStatusCode() == 302) {
                Header locationHeader = gm.getResponseHeader("Location");
                if (locationHeader == null) {
                    this.getLog().info((CharSequence)"Site sent redirect, but did not set Location header");
                } else {
                    String newLink = locationHeader.getValue();
                    this.getLog().debug((CharSequence)("Following redirect to " + newLink));
                    this.download(cl, newLink);
                }
            }
            if (gm.getStatusCode() != 200) {
                this.getLog().warn((CharSequence)("Received: [" + gm.getStatusCode() + "]"));
            }
        }
        catch (HttpException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"Error downloading issues from JIRA:", (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("Error downloading issues from JIRA url :  " + e.getLocalizedMessage()));
            }
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)"Error downloading issues from JIRA :", (Throwable)e);
            }
            this.getLog().error((CharSequence)("Error downloading issues from JIRA. Cause is " + e.getLocalizedMessage()));
        }
    }

    public void setOutput(File thisOutput) {
        this.output = thisOutput;
    }

    public void setMavenProject(Object thisProject) {
        this.project = (MavenProject)thisProject;
    }

    public void setNbEntries(int nbEntries) {
        this.nbEntriesMax = nbEntries;
    }

    public void setStatusIds(String thisStatusIds) {
        this.statusIds = thisStatusIds;
    }

    public void setPriorityIds(String thisPriorityIds) {
        this.priorityIds = thisPriorityIds;
    }

    public void setResolutionIds(String thisResolutionIds) {
        this.resolutionIds = thisResolutionIds;
    }

    public void setWebPassword(String thisWebPassword) {
        this.webPassword = thisWebPassword;
    }

    public void setWebUser(String thisWebUser) {
        this.webUser = thisWebUser;
    }

    public void setJiraPassword(String thisJiraPassword) {
        this.jiraPassword = thisJiraPassword;
    }

    public void setJiraUser(String thisJiraUser) {
        this.jiraUser = thisJiraUser;
    }

    public void setFilter(String thisFilter) {
        this.filter = thisFilter;
    }

    public void setComponent(String theseComponents) {
        this.component = theseComponents;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Log getLog() {
        return this.log;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    static {
        statusMap.put("Open", "1");
        statusMap.put("In Progress", "3");
        statusMap.put("Reopened", "4");
        statusMap.put("Resolved", "5");
        statusMap.put("Closed", "6");
        resolutionMap.put("Unresolved", "-1");
        resolutionMap.put("Fixed", "1");
        resolutionMap.put("Won't Fix", "2");
        resolutionMap.put("Duplicate", "3");
        resolutionMap.put("Incomplete", "4");
        resolutionMap.put("Cannot Reproduce", "5");
        priorityMap.put("Blocker", "1");
        priorityMap.put("Critical", "2");
        priorityMap.put("Major", "3");
        priorityMap.put("Minor", "4");
        priorityMap.put("Trivial", "5");
    }
}

