/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xdoc;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.model.BaseElement;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.model.VersionRange;
import org.codehaus.modello.plugin.xdoc.metadata.XdocFieldMetadata;
import org.codehaus.modello.plugin.xsd.XsdModelHelper;
import org.codehaus.modello.plugins.xml.AbstractXmlGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class XdocGenerator
extends AbstractXmlGenerator {
    private static final VersionRange DEFAULT_VERSION_RANGE = new VersionRange("0.0.0+");
    private Version firstVersion = DEFAULT_VERSION_RANGE.getFromVersion();
    private Version version = DEFAULT_VERSION_RANGE.getFromVersion();

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        if (parameters.getProperty("modello.first.version") != null) {
            this.firstVersion = new Version(parameters.getProperty("modello.first.version"));
        }
        if (parameters.getProperty("modello.version") != null) {
            this.version = new Version(parameters.getProperty("modello.version"));
        }
        try {
            this.generateXdoc(parameters);
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating XDoc.", (Throwable)ex);
        }
    }

    private void generateXdoc(Properties parameters) throws IOException {
        Model objectModel = this.getModel();
        File directory = this.getOutputDirectory();
        if (this.isPackageWithVersion()) {
            directory = new File(directory, this.getGeneratedVersion().toString());
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String xdocFileName = parameters.getProperty("modello.output.xdoc.file");
        File f = new File(directory, objectModel.getId() + ".xml");
        if (xdocFileName != null) {
            f = new File(directory, xdocFileName);
        }
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)f);
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        writer.write("<?xml version=\"1.0\"?>\n");
        this.initHeader((XMLWriter)w);
        w.startElement("document");
        w.startElement("properties");
        XdocGenerator.writeTextElement((XMLWriter)w, "title", objectModel.getName());
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", objectModel.getName());
        XdocGenerator.writeMarkupElement((XMLWriter)w, "p", XdocGenerator.getDescription((BaseElement)objectModel));
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        XdocGenerator.writeMarkupElement((XMLWriter)w, "source", "\n" + this.getModelXmlDescriptor(root));
        this.writeModelDescriptor((XMLWriter)w, root);
        w.endElement();
        w.endElement();
        w.endElement();
        writer.flush();
        writer.close();
    }

    private String getAnchorName(String tagName) {
        return "class_" + tagName;
    }

    private void writeModelDescriptor(XMLWriter w, ModelClass rootModelClass) {
        this.writeElementDescriptor(w, rootModelClass, null, new HashSet<String>());
    }

    private void writeElementDescriptor(XMLWriter w, ModelClass modelClass, ModelAssociation association, Set<String> written) {
        String tagName = this.resolveTagName(modelClass, association);
        String id = this.getId(tagName, modelClass);
        if (written.contains(id)) {
            return;
        }
        written.add(id);
        written.add(tagName);
        w.startElement("a");
        w.addAttribute("name", this.getAnchorName(tagName));
        w.endElement();
        w.startElement("subsection");
        w.addAttribute("name", tagName);
        XdocGenerator.writeMarkupElement(w, "p", XdocGenerator.getDescription((BaseElement)modelClass));
        List elementFields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        ModelField contentField = this.getContentField(elementFields);
        if (contentField != null) {
            w.startElement("p");
            XdocGenerator.writeTextElement(w, "b", "Element Content: ");
            w.writeMarkup(XdocGenerator.getDescription((BaseElement)contentField));
            w.endElement();
        }
        List attributeFields = this.getXmlAttributeFields(elementFields);
        elementFields.removeAll(attributeFields);
        this.writeFieldsTable(w, attributeFields, false);
        this.writeFieldsTable(w, elementFields, true);
        w.endElement();
        for (ModelField f : elementFields) {
            if (!this.isInnerAssociation(f)) continue;
            ModelAssociation assoc = (ModelAssociation)f;
            ModelClass fieldModelClass = this.getModel().getClass(assoc.getTo(), this.getGeneratedVersion());
            if (written.contains(this.getId(this.resolveTagName(fieldModelClass, assoc), fieldModelClass))) continue;
            this.writeElementDescriptor(w, fieldModelClass, assoc, written);
        }
    }

    private String getId(String tagName, ModelClass modelClass) {
        return tagName + '/' + modelClass.getPackageName() + '.' + modelClass.getName();
    }

    private void writeFieldsTable(XMLWriter w, List<ModelField> fields, boolean elementFields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        if (elementFields && fields.size() == 1 && this.hasContentField(fields)) {
            return;
        }
        w.startElement("table");
        w.startElement("tr");
        XdocGenerator.writeTextElement(w, "th", elementFields ? "Element" : "Attribute");
        XdocGenerator.writeTextElement(w, "th", "Type");
        boolean showSinceColumn = this.version.greaterThan(this.firstVersion);
        if (showSinceColumn) {
            XdocGenerator.writeTextElement(w, "th", "Since");
        }
        XdocGenerator.writeTextElement(w, "th", "Description");
        w.endElement();
        for (ModelField f : fields) {
            ModelAssociation assoc;
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)f.getMetadata(XmlFieldMetadata.ID);
            if (xmlFieldMetadata.isContent()) continue;
            w.startElement("tr");
            String tagName = this.resolveTagName(f, xmlFieldMetadata);
            w.startElement("td");
            w.startElement("code");
            boolean manyAssociation = false;
            if (f instanceof ModelAssociation) {
                String itemTagName;
                assoc = (ModelAssociation)f;
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)assoc.getAssociationMetadata(XmlAssociationMetadata.ID);
                manyAssociation = assoc.isManyMultiplicity();
                String string = itemTagName = manyAssociation ? this.resolveTagName(tagName, xmlAssociationMetadata) : tagName;
                if (manyAssociation && xmlAssociationMetadata.isWrappedItems()) {
                    w.writeText(tagName);
                    w.writeMarkup("/");
                }
                if (this.isInnerAssociation(f)) {
                    w.startElement("a");
                    w.addAttribute("href", "#" + this.getAnchorName(itemTagName));
                    w.writeText(itemTagName);
                    w.endElement();
                } else if ("java.util.Properties".equals(f.getType())) {
                    if (xmlAssociationMetadata.isMapExplode()) {
                        w.writeText("(key,value)");
                    } else {
                        w.writeMarkup("<i>key</i>=<i>value</i>");
                    }
                } else {
                    w.writeText(itemTagName);
                }
                if (manyAssociation) {
                    w.writeText("*");
                }
            } else {
                w.writeText(tagName);
            }
            w.endElement();
            w.endElement();
            w.startElement("td");
            w.startElement("code");
            if (f instanceof ModelAssociation) {
                assoc = (ModelAssociation)f;
                if (assoc.isOneMultiplicity()) {
                    w.writeText(assoc.getTo());
                } else {
                    w.writeText(assoc.getType().substring("java.util.".length()));
                    if (assoc.isGenericType()) {
                        w.writeText("<" + assoc.getTo() + ">");
                    }
                }
            } else {
                w.writeText(f.getType());
            }
            w.endElement();
            w.endElement();
            if (showSinceColumn) {
                Version fromVersion;
                w.startElement("td");
                if (f.getVersionRange() != null && (fromVersion = f.getVersionRange().getFromVersion()) != null && fromVersion.greaterThan(this.firstVersion)) {
                    w.writeMarkup(fromVersion.toString());
                }
                w.endElement();
            }
            w.startElement("td");
            if (manyAssociation) {
                w.writeMarkup("<b>(Many)</b> ");
            }
            w.writeMarkup(XdocGenerator.getDescription((BaseElement)f));
            if (f.getDefaultValue() != null && !(f instanceof ModelAssociation)) {
                w.writeMarkup("<br/><strong>Default value is</strong>: ");
                XdocGenerator.writeTextElement(w, "code", f.getDefaultValue());
                w.writeText(".");
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
    }

    private String getModelXmlDescriptor(ModelClass rootModelClass) {
        return this.getElementXmlDescriptor(rootModelClass, null, new Stack<String>());
    }

    private String getElementXmlDescriptor(ModelClass modelClass, ModelAssociation association, Stack<String> stack) throws ModelloRuntimeException {
        XmlFieldMetadata xmlFieldMetadata;
        String id;
        StringBuilder sb = new StringBuilder();
        XdocGenerator.appendSpacer(sb, stack.size());
        String tagName = this.resolveTagName(modelClass, association);
        sb.append("&lt;<a href=\"#").append(this.getAnchorName(tagName)).append("\">");
        sb.append(tagName).append("</a>");
        boolean addNewline = false;
        if (stack.size() == 0) {
            try {
                String targetNamespace = XsdModelHelper.getTargetNamespace((Model)modelClass.getModel(), (Version)this.getGeneratedVersion());
                XmlModelMetadata xmlModelMetadata = (XmlModelMetadata)modelClass.getModel().getMetadata(XmlModelMetadata.ID);
                if (StringUtils.isNotBlank((String)targetNamespace) && xmlModelMetadata.getSchemaLocation() != null) {
                    String schemaLocation = xmlModelMetadata.getSchemaLocation(this.getGeneratedVersion());
                    sb.append(" xmlns=\"" + targetNamespace + "\"");
                    sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                    sb.append("  xsi:schemaLocation=\"" + targetNamespace);
                    sb.append(" <a href=\"" + schemaLocation + "\">" + schemaLocation + "</a>\"");
                    addNewline = true;
                }
            }
            catch (ModelloException targetNamespace) {
                // empty catch block
            }
        }
        if (stack.contains(id = tagName + '/' + modelClass.getPackageName() + '.' + modelClass.getName())) {
            sb.append("&gt;...recursion...&lt;").append(tagName).append("&gt;\n");
            return sb.toString();
        }
        List fields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        List attributeFields = this.getXmlAttributeFields(fields);
        if (attributeFields.size() > 0) {
            for (ModelField f : attributeFields) {
                xmlFieldMetadata = (XmlFieldMetadata)f.getMetadata(XmlFieldMetadata.ID);
                if (addNewline) {
                    addNewline = false;
                    sb.append("\n  ");
                } else {
                    sb.append(' ');
                }
                sb.append(this.resolveTagName(f, xmlFieldMetadata)).append("=..");
            }
            sb.append(' ');
        }
        fields.removeAll(attributeFields);
        if (fields.size() == 0 || fields.size() == 1 && this.hasContentField(fields)) {
            sb.append("/&gt;\n");
        } else {
            sb.append("&gt;\n");
            stack.push(id);
            for (ModelField f : fields) {
                ModelAssociation assoc;
                xmlFieldMetadata = (XmlFieldMetadata)f.getMetadata(XmlFieldMetadata.ID);
                XdocFieldMetadata xdocFieldMetadata = (XdocFieldMetadata)f.getMetadata(XdocFieldMetadata.ID);
                if ("blank".equals(xdocFieldMetadata.getSeparator())) {
                    sb.append('\n');
                }
                String fieldTagName = this.resolveTagName(f, xmlFieldMetadata);
                if (this.isInnerAssociation(f)) {
                    assoc = (ModelAssociation)f;
                    boolean wrappedItems = false;
                    if (assoc.isManyMultiplicity()) {
                        XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)assoc.getAssociationMetadata(XmlAssociationMetadata.ID);
                        wrappedItems = xmlAssociationMetadata.isWrappedItems();
                    }
                    if (wrappedItems) {
                        XdocGenerator.appendSpacer(sb, stack.size());
                        sb.append("&lt;").append(fieldTagName).append("&gt;\n");
                        stack.push(fieldTagName);
                    }
                    ModelClass fieldModelClass = this.getModel().getClass(assoc.getTo(), this.getGeneratedVersion());
                    sb.append(this.getElementXmlDescriptor(fieldModelClass, assoc, stack));
                    if (!wrappedItems) continue;
                    stack.pop();
                    XdocGenerator.appendSpacer(sb, stack.size());
                    sb.append("&lt;/").append(fieldTagName).append("&gt;\n");
                    continue;
                }
                if ("java.util.Properties".equals(f.getType())) {
                    assoc = (ModelAssociation)f;
                    XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)assoc.getAssociationMetadata(XmlAssociationMetadata.ID);
                    XdocGenerator.appendSpacer(sb, stack.size());
                    sb.append("&lt;").append(fieldTagName).append("&gt;\n");
                    if (xmlAssociationMetadata.isMapExplode()) {
                        XdocGenerator.appendSpacer(sb, stack.size() + 1);
                        sb.append("&lt;key/&gt;\n");
                        XdocGenerator.appendSpacer(sb, stack.size() + 1);
                        sb.append("&lt;value/&gt;\n");
                    } else {
                        XdocGenerator.appendSpacer(sb, stack.size() + 1);
                        sb.append("&lt;<i>key</i>&gt;<i>value</i>&lt;/<i>key</i>&gt;\n");
                    }
                    XdocGenerator.appendSpacer(sb, stack.size());
                    sb.append("&lt;/").append(fieldTagName).append("&gt;\n");
                    continue;
                }
                XdocGenerator.appendSpacer(sb, stack.size());
                sb.append("&lt;").append(fieldTagName).append("/&gt;\n");
            }
            stack.pop();
            XdocGenerator.appendSpacer(sb, stack.size());
            sb.append("&lt;/").append(tagName).append("&gt;\n");
        }
        return sb.toString();
    }

    private String resolveTagName(ModelClass modelClass, ModelAssociation association) {
        String tagName;
        XmlClassMetadata xmlClassMetadata = (XmlClassMetadata)modelClass.getMetadata(XmlClassMetadata.ID);
        if (xmlClassMetadata == null || xmlClassMetadata.getTagName() == null) {
            if (association == null) {
                tagName = XdocGenerator.uncapitalise((String)modelClass.getName());
            } else {
                tagName = association.getName();
                if (association.isManyMultiplicity()) {
                    tagName = XdocGenerator.singular((String)tagName);
                }
            }
        } else {
            tagName = xmlClassMetadata.getTagName();
        }
        if (association != null) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)association.getMetadata(XmlFieldMetadata.ID);
            XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
            if (xmlFieldMetadata != null) {
                if (xmlAssociationMetadata.getTagName() != null) {
                    tagName = xmlAssociationMetadata.getTagName();
                } else if (xmlFieldMetadata.getTagName() != null) {
                    tagName = xmlFieldMetadata.getTagName();
                    if (association.isManyMultiplicity()) {
                        tagName = XdocGenerator.singular((String)tagName);
                    }
                }
            }
        }
        return tagName;
    }

    private static void appendSpacer(StringBuilder sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
    }

    private static String getDescription(BaseElement element) {
        return element.getDescription() == null ? "No description." : XdocGenerator.rewrite(element.getDescription());
    }

    private static void writeTextElement(XMLWriter w, String name, String text) {
        w.startElement(name);
        w.writeText(text);
        w.endElement();
    }

    private static void writeMarkupElement(XMLWriter w, String name, String markup) {
        w.startElement(name);
        w.writeMarkup(markup);
        w.endElement();
    }

    private static String rewrite(String text) {
        Document document = Jsoup.parseBodyFragment((String)text);
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        return document.body().html();
    }
}

