/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.store;

import java.io.File;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.store.metadata.StoreClassMetadata;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.velocity.VelocityComponent;

public class StoreModelloGenerator
extends AbstractModelloGenerator {
    private VelocityComponent velocity;

    public void generate(Model model, Properties properties) throws ModelloException {
        this.initialize(model, properties);
        VelocityContext context = new VelocityContext();
        context.put("version", (Object)this.getGeneratedVersion());
        context.put("package", (Object)model.getDefaultPackageName(false, this.getGeneratedVersion()));
        context.put("metadataId", (Object)StoreClassMetadata.ID);
        context.put("model", (Object)model);
        String packageName = model.getDefaultPackageName(false, this.getGeneratedVersion());
        File packageFile = new File(this.getOutputDirectory(), packageName.replace('.', File.separatorChar));
        File interfaceFile = new File(packageFile, model.getName() + "Store.java");
        File exceptionFile = new File(packageFile, model.getName() + "StoreException.java");
        if (!interfaceFile.getParentFile().exists() && !interfaceFile.getParentFile().mkdirs()) {
            throw new ModelloException("Error while creating parent directories for '" + interfaceFile.getAbsolutePath() + "'.");
        }
        String interfaceTemplate = "org/codehaus/modello/plugin/store/templates/Store.vm";
        String exceptionTemplate = "org/codehaus/modello/plugin/store/templates/StoreException.vm";
        this.writeTemplate(interfaceTemplate, interfaceFile, (Context)context);
        this.writeTemplate(exceptionTemplate, exceptionFile, (Context)context);
    }

    private void writeTemplate(String template, File file, Context context) throws ModelloException {
        try {
            Writer writer = this.getEncoding() == null ? WriterFactory.newPlatformWriter((File)file) : WriterFactory.newWriter((File)file, (String)this.getEncoding());
            this.velocity.getEngine().mergeTemplate(template, context, writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            throw new ModelloException("Error while generating code.", (Throwable)e);
        }
    }
}

