/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedMethodMap;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.introspect.MethodFilter;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedClass
extends Annotated {
    final Class<?> _class;
    final Collection<Class<?>> _superTypes;
    final AnnotationIntrospector _annotationIntrospector;
    AnnotationMap _classAnnotations;
    AnnotatedConstructor _defaultConstructor;
    List<AnnotatedConstructor> _singleArgConstructors;
    List<AnnotatedMethod> _singleArgStaticMethods;
    AnnotatedMethodMap _memberMethods;
    List<AnnotatedField> _fields;

    private AnnotatedClass(Class<?> cls, List<Class<?>> superTypes, AnnotationIntrospector aintr) {
        this._class = cls;
        this._superTypes = superTypes;
        this._annotationIntrospector = aintr;
    }

    public static AnnotatedClass construct(Class<?> cls, AnnotationIntrospector aintr) {
        List<Class<?>> st = ClassUtil.findSuperTypes(cls, null);
        AnnotatedClass ac = new AnnotatedClass(cls, st, aintr);
        ac.resolveClassAnnotations();
        return ac;
    }

    protected void resolveClassAnnotations() {
        this._classAnnotations = new AnnotationMap();
        for (Annotation a : this._class.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            this._classAnnotations.add(a);
        }
        for (Class<?> cls : this._superTypes) {
            for (Annotation a : cls.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                this._classAnnotations.addIfNotPresent(a);
            }
        }
    }

    public void resolveCreators(boolean includeAll) {
        this._singleArgConstructors = null;
        block4: for (Constructor<?> constructor : this._class.getDeclaredConstructors()) {
            switch (constructor.getParameterTypes().length) {
                case 0: {
                    this._defaultConstructor = this._constructConstructor(constructor);
                    continue block4;
                }
                case 1: {
                    if (!includeAll) continue block4;
                    if (this._singleArgConstructors == null) {
                        this._singleArgConstructors = new ArrayList<AnnotatedConstructor>();
                    }
                    this._singleArgConstructors.add(this._constructConstructor(constructor));
                }
            }
        }
        this._singleArgStaticMethods = null;
        if (includeAll) {
            for (Executable executable : this._class.getDeclaredMethods()) {
                int argCount;
                if (!Modifier.isStatic(((Method)executable).getModifiers()) || (argCount = ((Method)executable).getParameterTypes().length) != 1) continue;
                if (this._singleArgStaticMethods == null) {
                    this._singleArgStaticMethods = new ArrayList<AnnotatedMethod>();
                }
                this._singleArgStaticMethods.add(this._constructMethod((Method)executable));
            }
        }
    }

    public void resolveMemberMethods(MethodFilter methodFilter) {
        this._memberMethods = new AnnotatedMethodMap();
        for (Method m : this._class.getDeclaredMethods()) {
            if (!this._isIncludableMethod(m)) continue;
            this._memberMethods.add(this._constructMethod(m));
        }
        for (Class<?> cls : this._superTypes) {
            for (Method m : cls.getDeclaredMethods()) {
                if (!this._isIncludableMethod(m)) continue;
                AnnotatedMethod old = this._memberMethods.find(m);
                if (old == null) {
                    this._memberMethods.add(this._constructMethod(m));
                    continue;
                }
                for (Annotation a : m.getDeclaredAnnotations()) {
                    if (!this._annotationIntrospector.isHandled(a)) continue;
                    old.addIfNotPresent(a);
                }
            }
        }
        Iterator<AnnotatedMethod> it = this._memberMethods.iterator();
        while (it.hasNext()) {
            AnnotatedMethod am = it.next();
            if (!this._annotationIntrospector.isIgnorableMethod(am)) continue;
            it.remove();
        }
    }

    public void resolveFields() {
        this._fields = new ArrayList<AnnotatedField>();
        this._addFields(this._fields, this._class);
    }

    protected AnnotatedMethod _constructMethod(Method m) {
        return new AnnotatedMethod(m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()));
    }

    protected AnnotatedConstructor _constructConstructor(Constructor<?> ctor) {
        return new AnnotatedConstructor(ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()));
    }

    protected AnnotatedField _constructField(Field f) {
        return new AnnotatedField(f, this._collectRelevantAnnotations(f.getDeclaredAnnotations()));
    }

    protected AnnotationMap _collectRelevantAnnotations(Annotation[] anns) {
        AnnotationMap annMap = new AnnotationMap();
        if (anns != null) {
            for (Annotation a : anns) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                annMap.add(a);
            }
        }
        return annMap;
    }

    protected boolean _isIncludableMethod(Method m) {
        return !m.isSynthetic() && !m.isBridge();
    }

    private boolean _isIncludableField(Field f) {
        if (f.isSynthetic()) {
            return false;
        }
        int mods = f.getModifiers();
        return !Modifier.isStatic(mods) && !Modifier.isTransient(mods);
    }

    private void _addFields(List<AnnotatedField> fields, Class<?> c) {
        Class<?> parent = c.getSuperclass();
        if (parent != null) {
            this._addFields(fields, parent);
            for (Field f : c.getDeclaredFields()) {
                AnnotatedField af;
                if (!this._isIncludableField(f)) continue;
                Annotation[] anns = f.getAnnotations();
                int mods = f.getModifiers();
                if (!Modifier.isPublic(mods) && anns.length <= 0 || this._annotationIntrospector.isIgnorableField(af = this._constructField(f))) continue;
                fields.add(af);
            }
        }
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._classAnnotations == null) {
            return null;
        }
        return this._classAnnotations.get(acls);
    }

    @Override
    public Class<?> getType() {
        return this._class;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        return this._defaultConstructor;
    }

    public List<AnnotatedConstructor> getSingleArgConstructors() {
        if (this._singleArgConstructors == null) {
            return Collections.emptyList();
        }
        return this._singleArgConstructors;
    }

    public List<AnnotatedMethod> getSingleArgStaticMethods() {
        if (this._singleArgStaticMethods == null) {
            return Collections.emptyList();
        }
        return this._singleArgStaticMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        return this._memberMethods;
    }

    public int getMemberMethodCount() {
        return this._memberMethods.size();
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._memberMethods.find(name, paramTypes);
    }

    public int getFieldCount() {
        return this._fields == null ? 0 : this._fields.size();
    }

    public Iterable<AnnotatedField> fields() {
        if (this._fields == null) {
            List<AnnotatedField> l = Collections.emptyList();
            return l;
        }
        return this._fields;
    }

    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    public static final class FactoryMethodFilter
    implements MethodFilter {
        public static final FactoryMethodFilter instance = new FactoryMethodFilter();

        public boolean includeMethod(Method m) {
            if (!Modifier.isStatic(m.getModifiers())) {
                return false;
            }
            int argCount = m.getParameterTypes().length;
            if (argCount != 1) {
                return false;
            }
            Class<?> rt = m.getReturnType();
            return rt != Void.TYPE;
        }
    }
}

