/*
 * IzPack - Copyright 2001-2010 Julien Ponge, All Rights Reserved.
 *
 * http://izpack.org/
 * http://izpack.codehaus.org/
 *
 * Copyright 2009 Laurent Bovet, Alex Mathey
 * Copyright 2010, 2012 René Krell
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.izforge.izpack.util.xmlmerge.action;

import org.jdom2.Element;

import com.izforge.izpack.util.xmlmerge.Action;

/**
 * Copies the patch element if it exist in the original, keep the original if no corresponding patch
 * element exists.
 *
 * @author Laurent Bovet (LBO)
 * @author Alex Mathey (AMA)
 */
public class OverrideAction implements Action
{

    @Override
    public void perform(Element originalElement, Element patchElement, Element outputParentElement)
    {
        if (originalElement != null && patchElement != null)
        {
            outputParentElement.addContent((Element) patchElement.clone());
        }
        else if (originalElement != null)
        {
            outputParentElement.addContent((Element) originalElement.clone());
        }
    }

}
