/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.cumulative;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.cumulative.CumulativeConfig;

public class CumulativeVoteCountingStrategy
extends AbstractVoteCountingStrategy<CumulativeConfig> {
    public CumulativeVoteCountingStrategy() {
        super(CumulativeConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        Map<String, ChoiceScore> scores = this.newEmptyChoiceScoreMap(voters);
        BigDecimal weightSum = BigDecimal.ZERO;
        for (Voter voter : voters) {
            weightSum = weightSum.add(BigDecimal.valueOf(voter.getWeight()));
            this.addVoterChoices(voter, scores);
        }
        for (ChoiceScore choiceScore : scores.values()) {
            BigDecimal scoreValue = choiceScore.getScoreValue();
            if (scoreValue == null) continue;
            choiceScore.setScoreValue(scoreValue.divide(weightSum, RoundingMode.HALF_UP));
        }
        return this.orderByValues(scores.values(), null);
    }

    protected void addVoterChoices(Voter voter, Map<String, ChoiceScore> scores) {
        double voterWeight = voter.getWeight();
        for (VoteForChoice voteForChoice : voter.getVoteForChoices()) {
            Double voteValue = voteForChoice.getVoteValue();
            if (voteValue == null) continue;
            String choiceId = voteForChoice.getChoiceId();
            ChoiceScore choiceScore = scores.get(choiceId);
            double scoreToAdd = voteValue * voterWeight;
            choiceScore.addScoreValue(scoreToAdd);
        }
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = choiceScore.getScoreValue().doubleValue();
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }
}

