/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api;

import java.util.Arrays;
import org.chorem.pollen.votecounting.api.VoteCountingNotFound;

public enum VoteCountings {
    Normal(1),
    Cumulative(2),
    Condorcet(3),
    Number(4),
    Borda(5),
    InstantRunoff(6),
    Coombs(7),
    MajorityJudgment(8);

    @Deprecated(forRemoval=true)
    private final int legacyId;

    private VoteCountings(int legacyId) {
        this.legacyId = legacyId;
    }

    @Deprecated(forRemoval=true)
    public int getLegacyId() {
        return this.legacyId;
    }

    public String getI18nKey() {
        return this.name().substring(0, 1).toLowerCase() + this.name().substring(1);
    }

    @Deprecated
    public static VoteCountings forLegacyId(int legacyId) {
        return Arrays.stream(VoteCountings.values()).filter(vc -> vc.getLegacyId() == legacyId).findAny().orElseThrow(() -> new VoteCountingNotFound("Could not find strategy with id " + legacyId));
    }
}

