/*
 * #%L
 * Pollen :: VoteCounting Api
 * $Id: GroupVoteCountingResult.java 3708 2012-09-29 12:36:25Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-votecounting-api/src/main/java/org/chorem/pollen/votecounting/model/GroupVoteCountingResult.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class GroupVoteCountingResult implements Serializable {

    private static final long serialVersionUID = 1L;

    protected GroupOfVoter voter;

    protected Map<String, GroupOfVoter> groups;

    public static GroupVoteCountingResult newResult(GroupOfVoter voter,
                                                    Set<GroupOfVoter> groups) {
        GroupVoteCountingResult result = new GroupVoteCountingResult();
        result.setVoter(voter);
        groups.remove(voter);
        result.setGroups(groups);
        return result;
    }

    public VoteCountingResult getMainResult() {
        return voter.getResult();
    }

    public Set<String> getGroupIds() {
        return Sets.newHashSet(groups.keySet());
    }

    public VoteCountingResult getGroupResult(String groupId) {
        GroupOfVoter groupOfVoter = groups.get(groupId);
        VoteCountingResult result = groupOfVoter.getResult();
        return result;
    }

    public void setVoter(GroupOfVoter voter) {
        this.voter = voter;
    }

    public void setGroups(Set<GroupOfVoter> groups) {
        this.groups = Maps.uniqueIndex(groups, new Function<GroupOfVoter, String>() {
            @Override
            public String apply(GroupOfVoter input) {
                return input.getVoterId();
            }
        });
    }
}
