/*
 * #%L
 * Pollen :: VoteCounting Api
 * $Id: GroupOfVoter.java 3593 2012-08-12 11:01:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-votecounting-api/src/main/java/org/chorem/pollen/votecounting/model/GroupOfVoter.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.collect.Sets;

import java.util.Set;

/**
 * Group of voters.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class GroupOfVoter implements Voter {

    /** Id of the group of voters. */
    private String voterId;

    /** Weight of the group of voters. */
    private double weight;

    /** All votes for this group of voters. */
    private Set<VoteForChoice> voteForChoices;

    /** Set of voters for this group. */
    private Set<Voter> voters;

    /** Result for this group. */
    private VoteCountingResult result;

    public static GroupOfVoter newVoter(String voterId,
                                        double weight,
                                        Set<VoteForChoice> voteForChoices,
                                        Set<Voter> voters) {
        GroupOfVoter result = new GroupOfVoter();
        result.setVoterId(voterId);
        result.setWeight(weight);
        if (voters != null) {
            for (VoteForChoice voteForChoice : voteForChoices) {
                result.addVoteForChoice(voteForChoice);
            }
        }
        result.setVoters(voters);
        return result;
    }

    @Override
    public String getVoterId() {
        return voterId;
    }

    @Override
    public double getWeight() {
        return weight;
    }

    @Override
    public Set<VoteForChoice> getVoteForChoices() {
        if (voteForChoices == null) {
            voteForChoices = Sets.newHashSet();
        }
        return voteForChoices;
    }

    public Set<Voter> getVoters() {
        return voters;
    }

    public VoteCountingResult getResult() {
        return result;
    }

    @Override
    public void setVoterId(String voterId) {
        this.voterId = voterId;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public void addVoteForChoice(VoteForChoice voteForChoice) {
        getVoteForChoices().add(voteForChoice);
    }

    public void setVoters(Set<Voter> voters) {
        this.voters = voters;
    }

    public void setResult(VoteCountingResult result) {
        this.result = result;
    }
}
