/**
 * *##% Callao FileConfigLoader
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.utils;

import java.io.IOException;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

/**
 * Chargement de fichier propriete
 * @author Rémi Chapelet
*/
public class FileConfigLoader {

    /** log */
    private static final Log log = LogFactory.getLog(FileConfigLoader.class);

    /**
     * Charge le fichier de propriete donne en entree.
     *
     * @param filename Le fichier *filename*.properties
     * @return Le fichier de configuration pour la base de donnees
     */
    public static Properties LoadFile(String filename) {
        Properties conf = new Properties();
		try {
            // Resource permet d'aller chercher directement dans le repertoire
            // "resources" dans callao-service/src/main/resources
			Properties confAll = Resource.getConfigProperties(filename);
            for (String key : confAll.stringPropertyNames()) {
                conf.setProperty(key, confAll.getProperty(key));
            }
            if (log.isDebugEnabled()) {
                log.debug("File properties open : " +filename);
            }
			//conf.load(new FileInputStream(new File(filename)));
		} catch (IOException e) {
			log.error(e);
		}
        return conf;
    }
}