/**
 * *##% Callao ConvertTimeSpan
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.convertObject;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Transaction;
import org.chorem.callao.service.dto.JournalDTO;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.chorem.callao.service.dto.TransactionDTO;


/**
 * Transforme les objets TimeSpan : DTO, DAO et entity
 *
 * @author Rémi Chapelet
 */
public class ConvertTransaction  extends ConvertTopiaContext {

    private static final Log log = LogFactory.getLog(ConvertTransaction.class);

    private ConvertJournal convertJournal = new ConvertJournal();

    private ConvertTimeSpan convertTimeSpan = new ConvertTimeSpan();

    /**
     * 
     * @param transaction
     * @return
     */
    public TransactionDTO transactionEntityToDto(Transaction transaction)
    {
        TransactionDTO transactionDTO = new TransactionDTO();
        transactionDTO.setId(transaction.getTopiaId());
        transactionDTO.setEntryDate(transaction.getTransDate());
        transactionDTO.setVoucherRef(transaction.getVoucherRef());
        transactionDTO.setDescription(transaction.getDescription());
        /**
         * Converti le journal en DTO
         */
        JournalDTO journalDTO = convertJournal.journalEntityToDto(transaction.getJournal());
        transactionDTO.setJournalDTO(journalDTO);
        /**
         * Converti le timeSpan en DTO
         */
        TimeSpanDTO timeSpanDTO = convertTimeSpan.timeSpanEntityToDto(transaction.getTimeSpan());
        transactionDTO.setTimeSpanDTO(timeSpanDTO);
        return transactionDTO;
    }

}