/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.bgsegm;

import org.opencv.bgsegm.BackgroundSubtractorCNT;
import org.opencv.bgsegm.BackgroundSubtractorGMG;
import org.opencv.bgsegm.BackgroundSubtractorGSOC;
import org.opencv.bgsegm.BackgroundSubtractorLSBP;
import org.opencv.bgsegm.BackgroundSubtractorMOG;
import org.opencv.bgsegm.SyntheticSequenceGenerator;
import org.opencv.core.Mat;

public class Bgsegm {
    public static final int LSBP_CAMERA_MOTION_COMPENSATION_NONE = 0;
    public static final int LSBP_CAMERA_MOTION_COMPENSATION_LK = 1;

    public static BackgroundSubtractorCNT createBackgroundSubtractorCNT(int minPixelStability, boolean useHistory, int maxPixelStability, boolean isParallel) {
        BackgroundSubtractorCNT retVal = BackgroundSubtractorCNT.__fromPtr__(Bgsegm.createBackgroundSubtractorCNT_0(minPixelStability, useHistory, maxPixelStability, isParallel));
        return retVal;
    }

    public static BackgroundSubtractorCNT createBackgroundSubtractorCNT() {
        BackgroundSubtractorCNT retVal = BackgroundSubtractorCNT.__fromPtr__(Bgsegm.createBackgroundSubtractorCNT_1());
        return retVal;
    }

    public static BackgroundSubtractorGMG createBackgroundSubtractorGMG(int initializationFrames, double decisionThreshold) {
        BackgroundSubtractorGMG retVal = BackgroundSubtractorGMG.__fromPtr__(Bgsegm.createBackgroundSubtractorGMG_0(initializationFrames, decisionThreshold));
        return retVal;
    }

    public static BackgroundSubtractorGMG createBackgroundSubtractorGMG() {
        BackgroundSubtractorGMG retVal = BackgroundSubtractorGMG.__fromPtr__(Bgsegm.createBackgroundSubtractorGMG_1());
        return retVal;
    }

    public static BackgroundSubtractorGSOC createBackgroundSubtractorGSOC(int mc, int nSamples, float replaceRate, float propagationRate, int hitsThreshold, float alpha, float beta, float blinkingSupressionDecay, float blinkingSupressionMultiplier, float noiseRemovalThresholdFacBG, float noiseRemovalThresholdFacFG) {
        BackgroundSubtractorGSOC retVal = BackgroundSubtractorGSOC.__fromPtr__(Bgsegm.createBackgroundSubtractorGSOC_0(mc, nSamples, replaceRate, propagationRate, hitsThreshold, alpha, beta, blinkingSupressionDecay, blinkingSupressionMultiplier, noiseRemovalThresholdFacBG, noiseRemovalThresholdFacFG));
        return retVal;
    }

    public static BackgroundSubtractorGSOC createBackgroundSubtractorGSOC() {
        BackgroundSubtractorGSOC retVal = BackgroundSubtractorGSOC.__fromPtr__(Bgsegm.createBackgroundSubtractorGSOC_1());
        return retVal;
    }

    public static BackgroundSubtractorLSBP createBackgroundSubtractorLSBP(int mc, int nSamples, int LSBPRadius, float Tlower, float Tupper, float Tinc, float Tdec, float Rscale, float Rincdec, float noiseRemovalThresholdFacBG, float noiseRemovalThresholdFacFG, int LSBPthreshold, int minCount) {
        BackgroundSubtractorLSBP retVal = BackgroundSubtractorLSBP.__fromPtr__(Bgsegm.createBackgroundSubtractorLSBP_0(mc, nSamples, LSBPRadius, Tlower, Tupper, Tinc, Tdec, Rscale, Rincdec, noiseRemovalThresholdFacBG, noiseRemovalThresholdFacFG, LSBPthreshold, minCount));
        return retVal;
    }

    public static BackgroundSubtractorLSBP createBackgroundSubtractorLSBP() {
        BackgroundSubtractorLSBP retVal = BackgroundSubtractorLSBP.__fromPtr__(Bgsegm.createBackgroundSubtractorLSBP_1());
        return retVal;
    }

    public static BackgroundSubtractorMOG createBackgroundSubtractorMOG(int history, int nmixtures, double backgroundRatio, double noiseSigma) {
        BackgroundSubtractorMOG retVal = BackgroundSubtractorMOG.__fromPtr__(Bgsegm.createBackgroundSubtractorMOG_0(history, nmixtures, backgroundRatio, noiseSigma));
        return retVal;
    }

    public static BackgroundSubtractorMOG createBackgroundSubtractorMOG() {
        BackgroundSubtractorMOG retVal = BackgroundSubtractorMOG.__fromPtr__(Bgsegm.createBackgroundSubtractorMOG_1());
        return retVal;
    }

    public static SyntheticSequenceGenerator createSyntheticSequenceGenerator(Mat background, Mat object, double amplitude, double wavelength, double wavespeed, double objspeed) {
        SyntheticSequenceGenerator retVal = SyntheticSequenceGenerator.__fromPtr__(Bgsegm.createSyntheticSequenceGenerator_0(background.nativeObj, object.nativeObj, amplitude, wavelength, wavespeed, objspeed));
        return retVal;
    }

    public static SyntheticSequenceGenerator createSyntheticSequenceGenerator(Mat background, Mat object) {
        SyntheticSequenceGenerator retVal = SyntheticSequenceGenerator.__fromPtr__(Bgsegm.createSyntheticSequenceGenerator_1(background.nativeObj, object.nativeObj));
        return retVal;
    }

    private static native long createBackgroundSubtractorCNT_0(int var0, boolean var1, int var2, boolean var3);

    private static native long createBackgroundSubtractorCNT_1();

    private static native long createBackgroundSubtractorGMG_0(int var0, double var1);

    private static native long createBackgroundSubtractorGMG_1();

    private static native long createBackgroundSubtractorGSOC_0(int var0, int var1, float var2, float var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private static native long createBackgroundSubtractorGSOC_1();

    private static native long createBackgroundSubtractorLSBP_0(int var0, int var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, int var11, int var12);

    private static native long createBackgroundSubtractorLSBP_1();

    private static native long createBackgroundSubtractorMOG_0(int var0, int var1, double var2, double var4);

    private static native long createBackgroundSubtractorMOG_1();

    private static native long createSyntheticSequenceGenerator_0(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native long createSyntheticSequenceGenerator_1(long var0, long var2);
}

