/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.wavelet;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.alg.transform.wavelet.impl.ImplWaveletTransformBorder;
import boofcv.alg.transform.wavelet.impl.ImplWaveletTransformInner;
import boofcv.alg.transform.wavelet.impl.ImplWaveletTransformNaive;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlBorderCoef;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class WaveletTransformOps {
    public static void transform1(WaveletDescription<WlCoef_F32> desc, GrayF32 input, GrayF32 output, GrayF32 storage) {
        UtilWavelet.checkShape((ImageGray)input, (ImageGray)output);
        WlCoef_F32 coef = (WlCoef_F32)desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = (GrayF32)InputSanityCheck.declareOrReshape((ImageBase)output, (ImageBase)storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (input.getWidth() <= minSize || input.getHeight() <= minSize) {
            ImplWaveletTransformNaive.horizontal(desc.getBorder(), coef, input, storage);
            ImplWaveletTransformNaive.vertical(desc.getBorder(), coef, storage, output);
        } else {
            ImplWaveletTransformInner.horizontal(coef, input, storage);
            ImplWaveletTransformBorder.horizontal(desc.getBorder(), coef, input, storage);
            ImplWaveletTransformInner.vertical(coef, storage, output);
            ImplWaveletTransformBorder.vertical(desc.getBorder(), coef, storage, output);
        }
    }

    public static void transformN(WaveletDescription<WlCoef_F32> desc, GrayF32 input, GrayF32 output, GrayF32 storage, int numLevels) {
        if (numLevels == 1) {
            WaveletTransformOps.transform1(desc, input, output, storage);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), (ImageGray)input, (ImageGray)output, numLevels);
        storage = (GrayF32)InputSanityCheck.declareOrReshape((ImageBase)output, (ImageBase)storage);
        storage = (GrayF32)storage.subimage(0, 0, output.width, output.height, null);
        storage.subImage = false;
        WaveletTransformOps.transform1(desc, input, output, storage);
        for (int i = 2; i <= numLevels; ++i) {
            int width = output.width / 2;
            int height = output.height / 2;
            width += width % 2;
            height += height % 2;
            input = (GrayF32)input.subimage(0, 0, width, height, null);
            output = (GrayF32)output.subimage(0, 0, width, height, null);
            input.setTo((ImageGray)output);
            storage.reshape(width, height);
            WaveletTransformOps.transform1(desc, input, output, storage);
        }
    }

    public static void inverse1(WaveletDescription<WlCoef_F32> desc, GrayF32 input, GrayF32 output, GrayF32 storage, float minValue, float maxValue) {
        UtilWavelet.checkShape((ImageGray)output, (ImageGray)input);
        WlCoef_F32 coef = (WlCoef_F32)desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = (GrayF32)InputSanityCheck.declareOrReshape((ImageBase)input, (ImageBase)storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (output.getWidth() <= minSize || output.getHeight() <= minSize) {
            ImplWaveletTransformNaive.verticalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_F32>)desc.getInverse(), input, storage);
            ImplWaveletTransformNaive.horizontalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_F32>)desc.getInverse(), storage, output);
        } else {
            ImplWaveletTransformInner.verticalInverse((WlCoef_F32)desc.getInverse().getInnerCoefficients(), input, storage);
            ImplWaveletTransformBorder.verticalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_F32>)desc.getInverse(), input, storage);
            ImplWaveletTransformInner.horizontalInverse((WlCoef_F32)desc.getInverse().getInnerCoefficients(), storage, output);
            ImplWaveletTransformBorder.horizontalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_F32>)desc.getInverse(), storage, output);
        }
        if (minValue != -3.4028235E38f && maxValue != Float.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }

    public static void inverseN(WaveletDescription<WlCoef_F32> desc, GrayF32 input, GrayF32 output, GrayF32 storage, int numLevels, float minValue, float maxValue) {
        if (numLevels == 1) {
            WaveletTransformOps.inverse1(desc, input, output, storage, minValue, maxValue);
            PixelMath.boundImage(output, minValue, maxValue);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), (ImageGray)output, (ImageGray)input, numLevels);
        storage = (GrayF32)InputSanityCheck.declareOrReshape((ImageBase)input, (ImageBase)storage);
        storage = (GrayF32)storage.subimage(0, 0, input.width, input.height, null);
        storage.subImage = false;
        int scale = UtilWavelet.computeScale(numLevels);
        int width = input.width / scale;
        int height = input.height / scale;
        width += width % 2;
        height += height % 2;
        GrayF32 levelIn = (GrayF32)input.subimage(0, 0, width, height, null);
        GrayF32 levelOut = (GrayF32)output.subimage(0, 0, width, height, null);
        storage.reshape(width, height);
        WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, -3.4028235E38f, Float.MAX_VALUE);
        for (int i = numLevels - 1; i >= 1; --i) {
            levelIn.setTo((ImageGray)levelOut);
            if (i > 1) {
                width = input.width / (scale /= 2);
                height = input.height / scale;
                width += width % 2;
                height += height % 2;
                storage.reshape(width, height);
                levelIn = (GrayF32)input.subimage(0, 0, width, height, null);
                levelOut = (GrayF32)output.subimage(0, 0, width, height, null);
            } else {
                levelIn = input;
                levelOut = output;
            }
            storage.reshape(levelIn.width, levelIn.height);
            WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, -3.4028235E38f, Float.MAX_VALUE);
        }
        if (minValue != -3.4028235E38f && maxValue != Float.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }

    public static void transform1(WaveletDescription<WlCoef_I32> desc, GrayS32 input, GrayS32 output, GrayS32 storage) {
        UtilWavelet.checkShape((ImageGray)input, (ImageGray)output);
        WlCoef_I32 coef = (WlCoef_I32)desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = (GrayS32)InputSanityCheck.declareOrReshape((ImageBase)output, (ImageBase)storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (input.getWidth() <= minSize || input.getHeight() <= minSize) {
            ImplWaveletTransformNaive.horizontal(desc.getBorder(), coef, (GrayI)input, (GrayI)storage);
            ImplWaveletTransformNaive.vertical(desc.getBorder(), coef, (GrayI)storage, (GrayI)output);
        } else {
            ImplWaveletTransformInner.horizontal(coef, input, storage);
            ImplWaveletTransformBorder.horizontal(desc.getBorder(), coef, input, storage);
            ImplWaveletTransformInner.vertical(coef, storage, output);
            ImplWaveletTransformBorder.vertical(desc.getBorder(), coef, storage, output);
        }
    }

    public static void transformN(WaveletDescription<WlCoef_I32> desc, GrayS32 input, GrayS32 output, GrayS32 storage, int numLevels) {
        if (numLevels == 1) {
            WaveletTransformOps.transform1(desc, input, output, storage);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), (ImageGray)input, (ImageGray)output, numLevels);
        storage = (GrayS32)InputSanityCheck.declareOrReshape((ImageBase)output, (ImageBase)storage);
        storage = (GrayS32)storage.subimage(0, 0, output.width, output.height, null);
        storage.subImage = false;
        WaveletTransformOps.transform1(desc, input, output, storage);
        for (int i = 2; i <= numLevels; ++i) {
            int width = output.width / 2;
            int height = output.height / 2;
            width += width % 2;
            height += height % 2;
            input = (GrayS32)input.subimage(0, 0, width, height, null);
            output = (GrayS32)output.subimage(0, 0, width, height, null);
            input.setTo((ImageGray)output);
            storage.reshape(width, height);
            WaveletTransformOps.transform1(desc, input, output, storage);
        }
    }

    public static void inverse1(WaveletDescription<WlCoef_I32> desc, GrayS32 input, GrayS32 output, GrayS32 storage, int minValue, int maxValue) {
        UtilWavelet.checkShape((ImageGray)output, (ImageGray)input);
        WlCoef_I32 coef = (WlCoef_I32)desc.getForward();
        if (output.width < coef.scaling.length || output.width < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        if (output.height < coef.scaling.length || output.height < coef.wavelet.length) {
            throw new IllegalArgumentException("Wavelet is too large for provided image.");
        }
        storage = (GrayS32)InputSanityCheck.declareOrReshape((ImageBase)input, (ImageBase)storage);
        int minSize = Math.max(coef.getScalingLength(), coef.getWaveletLength()) * 3;
        if (output.getWidth() <= minSize || output.getHeight() <= minSize) {
            ImplWaveletTransformNaive.verticalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_I32>)desc.getInverse(), (GrayI)input, (GrayI)storage);
            ImplWaveletTransformNaive.horizontalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_I32>)desc.getInverse(), (GrayI)storage, (GrayI)output);
        } else {
            ImplWaveletTransformInner.verticalInverse((WlCoef_I32)desc.getInverse().getInnerCoefficients(), input, storage);
            ImplWaveletTransformBorder.verticalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_I32>)desc.getInverse(), input, storage);
            ImplWaveletTransformInner.horizontalInverse((WlCoef_I32)desc.getInverse().getInnerCoefficients(), storage, output);
            ImplWaveletTransformBorder.horizontalInverse(desc.getBorder(), (WlBorderCoef<WlCoef_I32>)desc.getInverse(), storage, output);
        }
        if (minValue != Integer.MIN_VALUE && maxValue != Integer.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }

    public static void inverseN(WaveletDescription<WlCoef_I32> desc, GrayS32 input, GrayS32 output, GrayS32 storage, int numLevels, int minValue, int maxValue) {
        if (numLevels == 1) {
            WaveletTransformOps.inverse1(desc, input, output, storage, minValue, maxValue);
            PixelMath.boundImage(output, minValue, maxValue);
            return;
        }
        UtilWavelet.checkShape(desc.getForward(), (ImageGray)output, (ImageGray)input, numLevels);
        storage = (GrayS32)InputSanityCheck.declareOrReshape((ImageBase)input, (ImageBase)storage);
        storage = (GrayS32)storage.subimage(0, 0, input.width, input.height, null);
        storage.subImage = false;
        int scale = UtilWavelet.computeScale(numLevels);
        int width = input.width / scale;
        int height = input.height / scale;
        width += width % 2;
        height += height % 2;
        GrayS32 levelIn = (GrayS32)input.subimage(0, 0, width, height, null);
        GrayS32 levelOut = (GrayS32)output.subimage(0, 0, width, height, null);
        storage.reshape(width, height);
        WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, Integer.MIN_VALUE, Integer.MAX_VALUE);
        for (int i = numLevels - 1; i >= 1; --i) {
            levelIn.setTo((ImageGray)levelOut);
            if (i > 1) {
                width = input.width / (scale /= 2);
                height = input.height / scale;
                width += width % 2;
                height += height % 2;
                storage.reshape(width, height);
                levelIn = (GrayS32)input.subimage(0, 0, width, height, null);
                levelOut = (GrayS32)output.subimage(0, 0, width, height, null);
            } else {
                levelIn = input;
                levelOut = output;
            }
            storage.reshape(levelIn.width, levelIn.height);
            WaveletTransformOps.inverse1(desc, levelIn, levelOut, storage, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (minValue != Integer.MIN_VALUE && maxValue != Integer.MAX_VALUE) {
            PixelMath.boundImage(output, minValue, maxValue);
        }
    }
}

