/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.filter.binary.ThresholdNiblackFamily;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;

public class ThresholdNiblackFamily_MT
extends ThresholdNiblackFamily {
    public ThresholdNiblackFamily_MT(ConfigLength width, float k, boolean down, ThresholdNiblackFamily.Variant variant) {
        super(width, k, down, variant);
    }

    @Override
    protected void applyThresholding(GrayF32 input, GrayU8 output) {
        if (this.down) {
            BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.op.compute(this.inputMean.data[i], this.stdev.data[i]);
                    output.data[indexOut++] = (byte)(input.data[indexIn++] <= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            });
        } else {
            BoofConcurrency.loopFor((int)0, (int)input.height, y -> {
                int i = y * this.stdev.width;
                int indexIn = input.startIndex + y * input.stride;
                int indexOut = output.startIndex + y * output.stride;
                int x = 0;
                while (x < input.width) {
                    float threshold = this.op.compute(this.inputMean.data[i], this.stdev.data[i]);
                    output.data[indexOut++] = (byte)(input.data[indexIn++] >= threshold ? 1 : 0);
                    ++x;
                    ++i;
                }
            });
        }
    }
}

