/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.v4_5.runner;

import java.lang.reflect.Method;
import org.assertj.swing.annotation.GUITestFinder;
import org.assertj.swing.junit.runner.FailureScreenshotTaker;
import org.assertj.swing.junit.runner.Formatter;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

class MethodInvoker
extends Statement {
    private final FrameworkMethod testMethod;
    private final Object target;
    private final FailureScreenshotTaker screenshotTaker;

    MethodInvoker(FrameworkMethod testMethod, Object target, FailureScreenshotTaker screenshotTaker) {
        this.testMethod = testMethod;
        this.target = target;
        this.screenshotTaker = screenshotTaker;
    }

    public void evaluate() throws Throwable {
        try {
            this.testMethod.invokeExplosively(this.target, new Object[0]);
        }
        catch (Throwable t) {
            this.takeScreenshot();
            throw t;
        }
    }

    private void takeScreenshot() {
        Method realMethod = this.testMethod.getMethod();
        Class<?> testClass = realMethod.getDeclaringClass();
        if (!GUITestFinder.isGUITest(testClass, (Method)realMethod)) {
            return;
        }
        this.screenshotTaker.saveScreenshot(Formatter.testNameFrom(testClass, (Method)realMethod));
    }
}

