/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldHaveSize
extends BasicErrorMessageFactory {
    private static final String SHOULD_HAVE_FILE_SIZE = "%nExpecting file%n  %s%nto have a size of:%n  %s bytes%nbut had:%n  %s bytes";
    private static final String SHOULD_HAVE_PATH_SIZE = "%nExpecting path%n  %s%nto have a size of:%n  %s bytes%nbut had:%n  %s bytes";

    public static ErrorMessageFactory shouldHaveSize(Object actual, int actualSize, int expectedSize, int firstDimensionArrayIndex) {
        return new ShouldHaveSize(actual, actualSize, expectedSize, firstDimensionArrayIndex);
    }

    public static ErrorMessageFactory shouldHaveSize(Object actual, int actualSize, int expectedSize) {
        return new ShouldHaveSize(actual, actualSize, expectedSize);
    }

    private ShouldHaveSize(Object actual, int actualSize, int expectedSize) {
        super(String.format("%nExpected size: %s but was: %s in:%n%s", expectedSize, actualSize, "%s"), actual);
    }

    private ShouldHaveSize(Object actual, int actualSize, int expectedSize, int firstDimensionArrayIndex) {
        super(String.format("%nExpected size: %s but was: %s in actual[%d]:%n%s", expectedSize, actualSize, firstDimensionArrayIndex, "%s"), actual);
    }

    public static ErrorMessageFactory shouldHaveSize(File actual, long expectedSize) {
        return new ShouldHaveSize(actual, expectedSize);
    }

    private ShouldHaveSize(File actual, long expectedSize) {
        super(SHOULD_HAVE_FILE_SIZE, actual, expectedSize, actual.length());
    }

    public static ErrorMessageFactory shouldHaveSize(Path actual, long expectedSize) throws IOException {
        return new ShouldHaveSize(actual, expectedSize);
    }

    private ShouldHaveSize(Path actual, long expectedSize) throws IOException {
        super(SHOULD_HAVE_PATH_SIZE, actual, expectedSize, Files.size(actual));
    }
}

