/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ClasspathResource {
    private final Map contentMappings = new HashMap();
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static ClasspathResource classpathResource;

    private ClasspathResource() {
        this.loadManifests();
    }

    public static synchronized ClasspathResource getInstance() {
        if (classpathResource == null) {
            classpathResource = new ClasspathResource();
        }
        return classpathResource;
    }

    private ClassLoader getClassLoaderForResources() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        return cl;
    }

    private void loadManifests() {
        try {
            Enumeration<URL> e = this.getClassLoaderForResources().getResources(MANIFEST_PATH);
            while (e.hasMoreElements()) {
                URL u = e.nextElement();
                try {
                    Manifest manifest = new Manifest(u.openStream());
                    Map<String, Attributes> entries = manifest.getEntries();
                    Iterator<Map.Entry<String, Attributes>> entrysetiterator = entries.entrySet().iterator();
                    while (entrysetiterator.hasNext()) {
                        Map.Entry<String, Attributes> entry = entrysetiterator.next();
                        String name = entry.getKey();
                        Attributes attributes = entry.getValue();
                        String contentType = attributes.getValue(CONTENT_TYPE_KEY);
                        if (contentType == null) continue;
                        this.addToMapping(contentType, name);
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addToMapping(String contentType, String name) {
        URL url;
        Vector<URL> existingFiles = (Vector<URL>)this.contentMappings.get(contentType);
        if (existingFiles == null) {
            existingFiles = new Vector<URL>();
            this.contentMappings.put(contentType, existingFiles);
        }
        if ((url = this.getClassLoaderForResources().getResource(name)) != null) {
            existingFiles.add(url);
        }
    }

    public List listResourcesOfMimeType(String mimeType) {
        List content = (List)this.contentMappings.get(mimeType);
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        return content;
    }
}

