/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree;

import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.table.ITreeColumn;
import org.apache.wicket.extensions.markup.html.repeater.tree.table.ITreeDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.table.NodeModel;
import org.apache.wicket.extensions.markup.html.repeater.tree.table.TreeDataProvider;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class TableTree<T, S>
extends AbstractTree<T> {
    private static final long serialVersionUID = 1L;
    private final DataTable<T, S> table;

    public TableTree(String id, List<? extends IColumn<T, S>> columns, ITreeProvider<T> dataProvider, long rowsPerPage) {
        this(id, columns, dataProvider, rowsPerPage, null);
    }

    public TableTree(String id, List<? extends IColumn<T, S>> columns, ITreeProvider<T> provider, long rowsPerPage, IModel<Set<T>> state) {
        super(id, provider, state);
        Args.notEmpty(columns, (String)"columns");
        for (IColumn<T, S> column : columns) {
            if (!(column instanceof ITreeColumn)) continue;
            ((ITreeColumn)column).setTree(this);
        }
        this.table = this.newDataTable("table", columns, this.newDataProvider(provider), rowsPerPage);
        this.add(new Component[]{this.table});
        this.setOutputMarkupId(true);
    }

    protected DataTable<T, S> newDataTable(String id, List<? extends IColumn<T, S>> columns, IDataProvider<T> dataProvider, long rowsPerPage) {
        return new DataTable<T, S>(id, columns, dataProvider, rowsPerPage){
            private static final long serialVersionUID = 1L;

            @Override
            protected Item<T> newRowItem(String id, int index, IModel<T> model) {
                Item item = TableTree.this.newRowItem(id, index, model);
                item.setOutputMarkupId(true);
                return item;
            }
        };
    }

    public DataTable<T, S> getTable() {
        return this.table;
    }

    public final TableTree<T, S> setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.table.setItemReuseStrategy(strategy);
        super.setItemReuseStrategy(strategy);
        return this;
    }

    @Override
    public void updateBranch(T node, AjaxRequestTarget target) {
        if (target != null) {
            target.add(new Component[]{this});
        }
    }

    @Override
    public void updateNode(T t, final AjaxRequestTarget target) {
        if (target != null) {
            final IModel model = this.getProvider().model(t);
            this.visitChildren(Item.class, new IVisitor<Item<T>, Void>(){

                public void component(Item<T> item, IVisit<Void> visit) {
                    NodeModel nodeModel = (NodeModel)item.getModel();
                    if (model.equals(nodeModel.getWrappedModel())) {
                        target.add(new Component[]{item});
                        visit.stop();
                        return;
                    }
                    visit.dontGoDeeper();
                }
            });
            model.detach();
        }
    }

    protected ITreeDataProvider<T> newDataProvider(ITreeProvider<T> provider) {
        return new TreeDataProvider<T>(provider){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean iterateChildren(T object) {
                return TableTree.this.getState(object) == AbstractTree.State.EXPANDED;
            }
        };
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        Item item = new Item(id, index, model);
        return item;
    }
}

