/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.sax.impl;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.vysper.charset.CharsetUtil;
import org.xml.sax.SAXException;

public class XMLTokenizer {
    private static final char NO_CHAR = '\uffff';
    private final IoBuffer buffer = IoBuffer.allocate((int)16).setAutoExpand(true);
    private State state = State.START;
    private TokenListener listener;

    public XMLTokenizer(TokenListener listeners) {
        this.listener = listeners;
    }

    public void parse(IoBuffer byteBuffer, CharsetDecoder decoder) throws SAXException {
        while (byteBuffer.hasRemaining() && this.state != State.CLOSED) {
            char c = (char)byteBuffer.get();
            if (this.state == State.START) {
                if (c == '<') {
                    this.emit(c, byteBuffer);
                    this.state = State.IN_TAG;
                    continue;
                }
                this.state = State.IN_TEXT;
                this.buffer.put((byte)c);
                continue;
            }
            if (this.state == State.IN_TEXT) {
                if (c == '<') {
                    this.emit(byteBuffer, decoder);
                    this.emit(c, byteBuffer);
                    this.state = State.IN_TAG;
                    continue;
                }
                this.buffer.put((byte)c);
                continue;
            }
            if (this.state == State.IN_TAG) {
                if (c == '>') {
                    this.emit(c, byteBuffer);
                    this.state = State.START;
                    continue;
                }
                if (c == '\"') {
                    this.emit(c, byteBuffer);
                    this.state = State.IN_DOUBLE_ATTRIBUTE_VALUE;
                    continue;
                }
                if (c == '\'') {
                    this.emit(c, byteBuffer);
                    this.state = State.IN_SINGLE_ATTRIBUTE_VALUE;
                    continue;
                }
                if (c == '-') {
                    this.emit(c, byteBuffer);
                    continue;
                }
                if (this.isControlChar(c)) {
                    this.emit(c, byteBuffer);
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    this.buffer.clear();
                    continue;
                }
                this.state = State.IN_STRING;
                this.buffer.put((byte)c);
                continue;
            }
            if (this.state == State.IN_STRING) {
                if (c == '>') {
                    this.emit(byteBuffer, CharsetUtil.UTF8_DECODER);
                    this.emit(c, byteBuffer);
                    this.state = State.START;
                    continue;
                }
                if (this.isControlChar(c)) {
                    this.emit(byteBuffer, CharsetUtil.UTF8_DECODER);
                    this.emit(c, byteBuffer);
                    this.state = State.IN_TAG;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    this.emit(byteBuffer, CharsetUtil.UTF8_DECODER);
                    this.state = State.IN_TAG;
                    continue;
                }
                this.buffer.put((byte)c);
                continue;
            }
            if (this.state == State.IN_DOUBLE_ATTRIBUTE_VALUE) {
                if (c == '\"') {
                    this.emit(byteBuffer, decoder);
                    this.emit(c, byteBuffer);
                    this.state = State.IN_TAG;
                    continue;
                }
                this.buffer.put((byte)c);
                continue;
            }
            if (this.state != State.IN_SINGLE_ATTRIBUTE_VALUE) continue;
            if (c == '\'') {
                this.emit(byteBuffer, decoder);
                this.emit(c, byteBuffer);
                this.state = State.IN_TAG;
                continue;
            }
            this.buffer.put((byte)c);
        }
    }

    public void close() {
        this.state = State.CLOSED;
        this.buffer.clear();
    }

    public void restart() {
        this.buffer.clear();
    }

    private boolean isControlChar(char c) {
        return c == '<' || c == '>' || c == '!' || c == '/' || c == '?' || c == '=';
    }

    private void emit(char token, IoBuffer byteBuffer) throws SAXException {
        this.listener.token(token, null);
    }

    private void emit(IoBuffer byteBuffer, CharsetDecoder decoder) throws SAXException {
        try {
            this.buffer.flip();
            this.listener.token('\uffff', this.buffer.getString(decoder));
            this.buffer.clear();
        }
        catch (CharacterCodingException e) {
            throw new SAXException(e);
        }
    }

    public static interface TokenListener {
        public void token(char var1, String var2) throws SAXException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START,
        IN_TAG,
        IN_STRING,
        IN_DOUBLE_ATTRIBUTE_VALUE,
        IN_SINGLE_ATTRIBUTE_VALUE,
        IN_TEXT,
        CLOSED;

    }
}

