/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.fragment;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityVerifier {
    private static AttributeComparator ATTRIBUTE_COMPARATOR = new AttributeComparator();

    public boolean equalsElements_Shallow(XMLElement first, XMLElement second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        if (!first.getNamespacePrefix().equals(second.getNamespacePrefix())) {
            return false;
        }
        return this.equalsAttributes(first.getAttributes(), second.getAttributes());
    }

    public boolean equalsElements_DeepSameOrder(XMLElement first, XMLElement second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        if (!first.getNamespacePrefix().equals(second.getNamespacePrefix())) {
            return false;
        }
        boolean attrEquals = this.equalsAttributes(first.getAttributes(), second.getAttributes());
        if (!attrEquals) {
            return false;
        }
        List<XMLElement> firstInnerElements = first.getInnerElements();
        List<XMLElement> secondInnerElements = second.getInnerElements();
        if (firstInnerElements.size() != secondInnerElements.size()) {
            return false;
        }
        for (int i = 0; i < firstInnerElements.size(); ++i) {
            if (this.equalsElements_DeepSameOrder(firstInnerElements.get(0), secondInnerElements.get(0))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsAttributes(List<Attribute> firstAttrs, List<Attribute> secondAttrs) {
        TreeSet<Attribute> attrSorted1 = new TreeSet<Attribute>(ATTRIBUTE_COMPARATOR);
        attrSorted1.addAll(firstAttrs);
        TreeSet<Attribute> attrSorted2 = new TreeSet<Attribute>(ATTRIBUTE_COMPARATOR);
        attrSorted2.addAll(secondAttrs);
        return attrSorted1.equals(attrSorted2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributeComparator
    implements Comparator<Attribute> {
        AttributeComparator() {
        }

        @Override
        public int compare(Attribute attribute1, Attribute attribute2) {
            if (attribute1.getName().equals(attribute2.getName())) {
                return attribute1.getValue().compareTo(attribute2.getValue());
            }
            return attribute1.getName().compareTo(attribute2.getName());
        }
    }
}

