/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.request.attribute.EnumeratedValuesExtractor;
import org.apache.tiles.request.collection.CollectionUtil;
import org.apache.tiles.request.collection.KeySet;
import org.apache.tiles.request.collection.MapEntry;
import org.apache.tiles.request.collection.MapEntryArrayValues;

public class HeaderValuesMap
implements Map<String, String[]> {
    private EnumeratedValuesExtractor request;

    public HeaderValuesMap(EnumeratedValuesExtractor request) {
        this.request = request;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getValue(CollectionUtil.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof String[])) {
            return false;
        }
        String[] test = (String[])value;
        Enumeration<String> names = this.request.getKeys();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (!this.compareHeaders(name, this.array2set(test))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String[]>> entrySet() {
        return new HeadersEntrySet();
    }

    @Override
    public boolean equals(Object o) {
        EnumeratedValuesExtractor otherRequest = ((HeaderValuesMap)o).request;
        boolean retValue = true;
        Enumeration<String> attribs = this.request.getKeys();
        while (attribs.hasMoreElements() && retValue) {
            String parameterName = attribs.nextElement();
            Set<String> valueSet = this.enumeration2set(otherRequest.getValues(parameterName));
            retValue = this.compareHeaders(parameterName, valueSet);
        }
        return retValue;
    }

    @Override
    public String[] get(Object key) {
        return this.getHeaderValues(CollectionUtil.key(key));
    }

    @Override
    public int hashCode() {
        int retValue = 0;
        Enumeration<String> attribs = this.request.getKeys();
        while (attribs.hasMoreElements()) {
            String parameterName = attribs.nextElement();
            Enumeration<String> values = this.request.getValues(parameterName);
            int valueHash = 0;
            while (values.hasMoreElements()) {
                valueHash += values.nextElement().hashCode();
            }
            retValue += parameterName.hashCode() ^ valueHash;
        }
        return retValue;
    }

    @Override
    public boolean isEmpty() {
        return !this.request.getKeys().hasMoreElements();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.request);
    }

    @Override
    public String[] put(String key, String[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String[]> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return CollectionUtil.enumerationSize(this.request.getKeys());
    }

    @Override
    public Collection<String[]> values() {
        return new HeaderValuesCollection();
    }

    private String[] getHeaderValues(String key) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> values = this.request.getValues(key);
        while (values.hasMoreElements()) {
            list.add(values.nextElement());
        }
        String[] retValue = list.toArray(new String[list.size()]);
        return retValue;
    }

    private Set<String> enumeration2set(Enumeration<String> enumeration) {
        HashSet<String> retValue = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            retValue.add(enumeration.nextElement());
        }
        return retValue;
    }

    private Set<String> array2set(String[] valueArray) {
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < valueArray.length; ++i) {
            values.add(valueArray[i]);
        }
        return values;
    }

    private boolean compareHeaders(String name, Set<String> testSet) {
        Enumeration<String> values = this.request.getValues(name);
        boolean matched = true;
        while (values.hasMoreElements() && matched) {
            String currentValue = values.nextElement();
            matched = testSet.remove(currentValue);
        }
        matched = matched && testSet.isEmpty();
        return matched;
    }

    private class HeaderValuesCollection
    implements Collection<String[]> {
        private HeaderValuesCollection() {
        }

        @Override
        public boolean add(String[] e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String[]> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return HeaderValuesMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Collection<?> realCollection = c;
            for (String[] value : realCollection) {
                if (HeaderValuesMap.this.containsValue(value)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return HeaderValuesMap.this.isEmpty();
        }

        @Override
        public Iterator<String[]> iterator() {
            return new HeaderValuesCollectionIterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return HeaderValuesMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toList().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.toList().toArray(a);
        }

        private List<String[]> toList() {
            ArrayList<String[]> entries = new ArrayList<String[]>();
            Enumeration<String> names = HeaderValuesMap.this.request.getKeys();
            while (names.hasMoreElements()) {
                entries.add(this.enumeration2array(HeaderValuesMap.this.request.getValues(names.nextElement())));
            }
            return entries;
        }

        private String[] enumeration2array(Enumeration<String> enumeration) {
            ArrayList<String> list1 = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                list1.add(enumeration.nextElement());
            }
            return list1.toArray(new String[list1.size()]);
        }

        private class HeaderValuesCollectionIterator
        implements Iterator<String[]> {
            private Enumeration<String> namesEnumeration;

            private HeaderValuesCollectionIterator() {
                this.namesEnumeration = HeaderValuesMap.this.request.getKeys();
            }

            @Override
            public boolean hasNext() {
                return this.namesEnumeration.hasMoreElements();
            }

            @Override
            public String[] next() {
                return HeaderValuesCollection.this.enumeration2array(HeaderValuesMap.this.request.getValues(this.namesEnumeration.nextElement()));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class HeadersEntrySet
    implements Set<Map.Entry<String, String[]>> {
        private HeadersEntrySet() {
        }

        @Override
        public boolean add(Map.Entry<String, String[]> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, String[]>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.containsEntry((Map.Entry)o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Collection<?> realCollection = c;
            for (Map.Entry entry : realCollection) {
                if (this.containsEntry(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return HeaderValuesMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, String[]>> iterator() {
            return new HeadersEntrySetIterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return HeaderValuesMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return this.toList().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.toList().toArray(a);
        }

        private boolean containsEntry(Map.Entry<String, String[]> entry) {
            Enumeration<String> entryValues = HeaderValuesMap.this.request.getValues(CollectionUtil.key(entry.getKey()));
            String[] valueArray = entry.getValue();
            Set values = HeaderValuesMap.this.array2set(valueArray);
            while (entryValues.hasMoreElements()) {
                if (values.remove(entryValues.nextElement())) continue;
                return false;
            }
            return values.isEmpty();
        }

        private List<Map.Entry<String, String[]>> toList() {
            ArrayList<Map.Entry<String, String[]>> entries = new ArrayList<Map.Entry<String, String[]>>();
            Enumeration<String> names = HeaderValuesMap.this.request.getKeys();
            while (names.hasMoreElements()) {
                entries.add(this.extractNextEntry(names));
            }
            return entries;
        }

        private MapEntry<String, String[]> extractNextEntry(Enumeration<String> names) {
            String name = names.nextElement();
            return new MapEntryArrayValues<String, String>(name, HeaderValuesMap.this.getHeaderValues(name), false);
        }

        private class HeadersEntrySetIterator
        implements Iterator<Map.Entry<String, String[]>> {
            private Enumeration<String> namesEnumeration;

            private HeadersEntrySetIterator() {
                this.namesEnumeration = HeaderValuesMap.this.request.getKeys();
            }

            @Override
            public boolean hasNext() {
                return this.namesEnumeration.hasMoreElements();
            }

            @Override
            public Map.Entry<String, String[]> next() {
                return HeadersEntrySet.this.extractNextEntry(this.namesEnumeration);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

