/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kinesis.spout;

import java.io.Serializable;

public class ZkInfo
implements Serializable {
    private final String zkUrl;
    private final String zkNode;
    private final Integer sessionTimeoutMs;
    private final Integer connectionTimeoutMs;
    private final Long commitIntervalMs;
    private final Integer retryAttempts;
    private final Integer retryIntervalMs;

    public ZkInfo(String zkUrl, String zkNode, Integer sessionTimeoutMs, Integer connectionTimeoutMs, Long commitIntervalMs, Integer retryAttempts, Integer retryIntervalMs) {
        this.zkUrl = zkUrl;
        this.zkNode = zkNode;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.commitIntervalMs = commitIntervalMs;
        this.retryAttempts = retryAttempts;
        this.retryIntervalMs = retryIntervalMs;
        this.validate();
    }

    public String getZkUrl() {
        return this.zkUrl;
    }

    public String getZkNode() {
        return this.zkNode;
    }

    public Integer getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public Integer getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public Long getCommitIntervalMs() {
        return this.commitIntervalMs;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public Integer getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    private void validate() {
        if (this.zkUrl == null || this.zkUrl.length() < 1) {
            throw new IllegalArgumentException("zkUrl must be specified to connect to zookeeper");
        }
        if (this.zkNode == null || this.zkNode.length() < 1) {
            throw new IllegalArgumentException("zkNode must be specified");
        }
        this.checkPositive(this.sessionTimeoutMs, "sessionTimeoutMs");
        this.checkPositive(this.connectionTimeoutMs, "connectionTimeoutMs");
        this.checkPositive(this.commitIntervalMs, "commitIntervalMs");
        this.checkPositive(this.retryAttempts, "retryAttempts");
        this.checkPositive(this.retryIntervalMs, "retryIntervalMs");
    }

    private void checkPositive(Integer argument, String name) {
        if (argument == null && argument <= 0) {
            throw new IllegalArgumentException(name + " must be positive");
        }
    }

    private void checkPositive(Long argument, String name) {
        if (argument == null && argument <= 0L) {
            throw new IllegalArgumentException(name + " must be positive");
        }
    }

    public String toString() {
        return "ZkInfo{zkUrl='" + this.zkUrl + '\'' + ", zkNode='" + this.zkNode + '\'' + ", sessionTimeoutMs=" + this.sessionTimeoutMs + ", connectionTimeoutMs=" + this.connectionTimeoutMs + ", commitIntervalMs=" + this.commitIntervalMs + ", retryAttempts=" + this.retryAttempts + ", retryIntervalMs=" + this.retryIntervalMs + '}';
    }
}

