/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kinesis.spout;

import java.util.Map;
import org.apache.storm.kinesis.spout.KinesisConfig;
import org.apache.storm.kinesis.spout.KinesisMessageId;
import org.apache.storm.kinesis.spout.KinesisRecordsManager;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;

public class KinesisSpout
extends BaseRichSpout {
    private final KinesisConfig kinesisConfig;
    private transient KinesisRecordsManager kinesisRecordsManager;
    private transient SpoutOutputCollector collector;

    public KinesisSpout(KinesisConfig kinesisConfig) {
        this.kinesisConfig = kinesisConfig;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this.kinesisConfig.getRecordToTupleMapper().getOutputFields());
    }

    public Map<String, Object> getComponentConfiguration() {
        return super.getComponentConfiguration();
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.collector = collector;
        this.kinesisRecordsManager = new KinesisRecordsManager(this.kinesisConfig);
        this.kinesisRecordsManager.initialize(context.getThisTaskIndex(), context.getComponentTasks(context.getThisComponentId()).size());
    }

    public void close() {
        this.kinesisRecordsManager.close();
    }

    public void activate() {
        this.kinesisRecordsManager.activate();
    }

    public void deactivate() {
        this.kinesisRecordsManager.deactivate();
    }

    public void ack(Object msgId) {
        this.kinesisRecordsManager.ack((KinesisMessageId)msgId);
    }

    public void fail(Object msgId) {
        this.kinesisRecordsManager.fail((KinesisMessageId)msgId);
    }

    public void nextTuple() {
        this.kinesisRecordsManager.next(this.collector);
    }
}

