/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kinesis.spout;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KinesisConnectionInfo
implements Serializable {
    private final byte[] serializedKinesisCredsProvider;
    private final byte[] serializedkinesisClientConfig;
    private final Integer recordsLimit;
    private final Regions region;
    private transient AWSCredentialsProvider credentialsProvider;
    private transient ClientConfiguration clientConfiguration;

    public KinesisConnectionInfo(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, Regions region, Integer recordsLimit) {
        if (recordsLimit == null || recordsLimit <= 0) {
            throw new IllegalArgumentException("recordsLimit has to be a positive integer");
        }
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null");
        }
        this.serializedKinesisCredsProvider = this.getKryoSerializedBytes(credentialsProvider);
        this.serializedkinesisClientConfig = this.getKryoSerializedBytes(clientConfiguration);
        this.recordsLimit = recordsLimit;
        this.region = region;
    }

    public Integer getRecordsLimit() {
        return this.recordsLimit;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        if (this.credentialsProvider == null) {
            this.credentialsProvider = (AWSCredentialsProvider)this.getKryoDeserializedObject(this.serializedKinesisCredsProvider);
        }
        return this.credentialsProvider;
    }

    public ClientConfiguration getClientConfiguration() {
        if (this.clientConfiguration == null) {
            this.clientConfiguration = (ClientConfiguration)this.getKryoDeserializedObject(this.serializedkinesisClientConfig);
        }
        return this.clientConfiguration;
    }

    public Regions getRegion() {
        return this.region;
    }

    private byte[] getKryoSerializedBytes(Object obj) {
        Kryo kryo = new Kryo();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)os);
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        kryo.writeClassAndObject(output, obj);
        output.flush();
        return os.toByteArray();
    }

    private Object getKryoDeserializedObject(byte[] ser) {
        Kryo kryo = new Kryo();
        Input input = new Input((InputStream)new ByteArrayInputStream(ser));
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        return kryo.readClassAndObject(input);
    }

    public String toString() {
        return "KinesisConnectionInfo{serializedKinesisCredsProvider=" + Arrays.toString(this.serializedKinesisCredsProvider) + ", serializedkinesisClientConfig=" + Arrays.toString(this.serializedkinesisClientConfig) + ", region=" + this.region + ", recordsLimit=" + this.recordsLimit + '}';
    }
}

