/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.kernel;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContextBuilder;
import org.apache.shardingsphere.infra.executor.sql.log.SQLLogger;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rewrite.SQLRewriteEntry;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.SQLRouteEngine;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class KernelProcessor {
    public ExecutionContext generateExecutionContext(QueryContext queryContext, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData, ConfigurationProperties props, ConnectionContext connectionContext) {
        RouteContext routeContext = this.route(queryContext, database, globalRuleMetaData, props, connectionContext);
        SQLRewriteResult rewriteResult = this.rewrite(queryContext, database, globalRuleMetaData, props, routeContext, connectionContext);
        ExecutionContext result = this.createExecutionContext(queryContext, database, routeContext, rewriteResult);
        this.logSQL(queryContext, props, result);
        return result;
    }

    private RouteContext route(QueryContext queryContext, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData, ConfigurationProperties props, ConnectionContext connectionContext) {
        return new SQLRouteEngine(database.getRuleMetaData().getRules(), props).route(connectionContext, queryContext, globalRuleMetaData, database);
    }

    private SQLRewriteResult rewrite(QueryContext queryContext, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData, ConfigurationProperties props, RouteContext routeContext, ConnectionContext connectionContext) {
        SQLRewriteEntry sqlRewriteEntry = new SQLRewriteEntry(database, globalRuleMetaData, props);
        return sqlRewriteEntry.rewrite(queryContext, routeContext, connectionContext);
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext, ShardingSphereDatabase database, RouteContext routeContext, SQLRewriteResult rewriteResult) {
        return new ExecutionContext(queryContext, ExecutionContextBuilder.build((ShardingSphereDatabase)database, (SQLRewriteResult)rewriteResult, (SQLStatementContext)queryContext.getSqlStatementContext()), routeContext);
    }

    private void logSQL(QueryContext queryContext, ConfigurationProperties props, ExecutionContext executionContext) {
        if (((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SHOW)).booleanValue()) {
            SQLLogger.logSQL((QueryContext)queryContext, (boolean)((Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_SIMPLE)), (ExecutionContext)executionContext);
        }
    }
}

