/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.ProducerFactory;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.container.AnnotatedTypeWrapper;
import org.apache.webbeans.util.WebBeansUtil;

public class AbstractProducerBean<T>
extends AbstractOwbBean<T> {
    private Class<T> returnType;
    private Producer<T> producer;
    private InjectionTargetBean<?> ownerComponent;

    public AbstractProducerBean(InjectionTargetBean<?> ownerComponent, WebBeansType webBeansType, BeanAttributes<T> beanAttributes, Class<T> returnType, ProducerFactory<?> producerFactory) {
        super(ownerComponent.webBeansContext, webBeansType, beanAttributes, ownerComponent.getBeanClass());
        this.returnType = returnType;
        this.ownerComponent = ownerComponent;
        this.producer = producerFactory.createProducer((Bean)this);
    }

    @Override
    public Producer<T> getProducer() {
        return this.producer;
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    public InjectionTargetBean<?> getOwnerComponent() {
        return this.ownerComponent;
    }

    @Override
    protected String providedId() {
        if (this.ownerComponent.getAnnotatedType() instanceof AnnotatedTypeWrapper) {
            return ((AnnotatedTypeWrapper)this.ownerComponent.getAnnotatedType()).getId();
        }
        return null;
    }

    protected void checkNullInstance(Object instance, String producerName) {
        String errorMessage = "WebBeans producer : %s return type in the component implementation class : %s scope type must be @Dependent to create null instance";
        WebBeansUtil.checkNullInstance(instance, this.getScope(), errorMessage, producerName, this.getBeanClass().getName());
    }

    protected void checkScopeType(String producerName, Object instance) {
        String errorMessage = "WebBeans producer : %s instance in the component implementation class : %s with passivating scope @%s must be Serializable";
        this.getWebBeansContext().getWebBeansUtil().checkSerializableScopeType(this.getScope(), Serializable.class.isInstance(instance), errorMessage, producerName, this.getBeanClass().getName(), this.getScope().getName());
    }

    protected boolean isPassivationCapable(Class<?> returnType, Integer modifiers) {
        return !Modifier.isFinal(modifiers) || Serializable.class.isAssignableFrom(returnType);
    }
}

