/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.AroundInvoke;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InterceptedMarker;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.spi.BeanAttributes;
import org.apache.webbeans.component.spi.InjectionTargetFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.CDI11s;

public class InjectionTargetBean<T>
extends AbstractOwbBean<T> {
    private AnnotatedType<T> annotatedType;
    private InjectionTarget<T> injectionTarget;

    public InjectionTargetBean(WebBeansContext webBeansContext, WebBeansType webBeansType, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes, Class<T> beanClass) {
        this(webBeansContext, webBeansType, annotatedType, beanAttributes, beanClass, new InjectionTargetFactoryImpl<T>(annotatedType, webBeansContext));
    }

    public InjectionTargetBean(WebBeansContext webBeansContext, WebBeansType webBeansType, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes, Class<T> beanClass, InjectionTargetFactory<T> factory) {
        super(webBeansContext, webBeansType, beanAttributes, beanClass, false);
        Asserts.assertNotNull(annotatedType, "AnnotatedType may not be null");
        this.annotatedType = annotatedType;
        this.injectionTarget = factory.createInjectionTarget(this);
        this.setEnabled(true);
    }

    @Override
    public InjectionTarget<T> getProducer() {
        return this.injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    public AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    public <T> void defineBeanInterceptorStack() {
        if (this instanceof InterceptedMarker && this.getInjectionTarget() instanceof InjectionTargetImpl) {
            InjectionTargetImpl injectionTarget = (InjectionTargetImpl)this.getInjectionTarget();
            InterceptorResolutionService.BeanInterceptorInfo interceptorInfo = this.webBeansContext.getInterceptorResolutionService().calculateInterceptorInfo(this.getTypes(), this.getQualifiers(), this.getAnnotatedType());
            HashMap methodInterceptors = new HashMap();
            for (Map.Entry<Method, InterceptorResolutionService.BusinessMethodInterceptorInfo> miEntry : interceptorInfo.getBusinessMethodsInfo().entrySet()) {
                Method interceptedMethod = miEntry.getKey();
                InterceptorResolutionService.BusinessMethodInterceptorInfo mii = miEntry.getValue();
                ArrayList activeInterceptors = new ArrayList();
                if (mii.getEjbInterceptors() != null) {
                    Collections.addAll(activeInterceptors, mii.getEjbInterceptors());
                }
                if (mii.getCdiInterceptors() != null) {
                    Collections.addAll(activeInterceptors, mii.getCdiInterceptors());
                }
                if (interceptorInfo.getSelfInterceptorBean() != null && interceptedMethod.getAnnotation(AroundInvoke.class) == null) {
                    activeInterceptors.add(interceptorInfo.getSelfInterceptorBean());
                }
                if (activeInterceptors.size() > 0) {
                    methodInterceptors.put(interceptedMethod, activeInterceptors);
                    continue;
                }
                if (mii.getMethodDecorators() == null) continue;
                methodInterceptors.put(interceptedMethod, Collections.EMPTY_LIST);
            }
            List<Interceptor<?>> postConstructInterceptors = this.getLifecycleInterceptors(interceptorInfo.getEjbInterceptors(), interceptorInfo.getCdiInterceptors(), InterceptionType.POST_CONSTRUCT);
            List<Interceptor<?>> preDestroyInterceptors = this.getLifecycleInterceptors(interceptorInfo.getEjbInterceptors(), interceptorInfo.getCdiInterceptors(), InterceptionType.PRE_DESTROY);
            List<Object> aroundConstruct = CDI11s.AROUND_CONSTRUCT != null ? this.getLifecycleInterceptors(interceptorInfo.getEjbInterceptors(), interceptorInfo.getCdiInterceptors(), CDI11s.AROUND_CONSTRUCT) : new ArrayList();
            Class proxyClass = null;
            if (methodInterceptors.size() > 0 || postConstructInterceptors.size() > 0 || preDestroyInterceptors.size() > 0) {
                InterceptorDecoratorProxyFactory pf = this.webBeansContext.getInterceptorDecoratorProxyFactory();
                ClassLoader classLoader = this.getBeanClass().getClassLoader();
                Method[] businessMethods = methodInterceptors.keySet().toArray(new Method[methodInterceptors.size()]);
                Method[] nonInterceptedMethods = interceptorInfo.getNonInterceptedMethods().toArray(new Method[interceptorInfo.getNonInterceptedMethods().size()]);
                proxyClass = pf.createProxyClass(this, classLoader, this.getReturnType(), businessMethods, nonInterceptedMethods);
            }
            injectionTarget.setInterceptorInfo(interceptorInfo, proxyClass, methodInterceptors, postConstructInterceptors, preDestroyInterceptors, aroundConstruct, this.getId());
        }
    }

    private List<Interceptor<?>> getLifecycleInterceptors(LinkedHashSet<Interceptor<?>> ejbInterceptors, List<Interceptor<?>> cdiInterceptors, InterceptionType interceptionType) {
        ArrayList lifecycleInterceptors = new ArrayList();
        for (Interceptor interceptor : ejbInterceptors) {
            if (!interceptor.intercepts(interceptionType)) continue;
            lifecycleInterceptors.add(interceptor);
        }
        for (Interceptor interceptor : cdiInterceptors) {
            if (!interceptor.intercepts(interceptionType)) continue;
            lifecycleInterceptors.add(interceptor);
        }
        return lifecycleInterceptors;
    }
}

