/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.lang.en;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import opennlp.tools.parser.Constituent;
import opennlp.tools.parser.GapLabeler;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class HeadRules
implements opennlp.tools.parser.HeadRules,
GapLabeler,
SerializableArtifact {
    private Map<String, HeadRule> headRules;
    private Set<String> punctSet;

    @Deprecated
    public HeadRules(String ruleFile) throws IOException {
        this(new BufferedReader(new FileReader(ruleFile)));
    }

    public HeadRules(Reader rulesReader) throws IOException {
        BufferedReader in = new BufferedReader(rulesReader);
        this.readHeadRules(in);
        this.punctSet = new HashSet<String>();
        this.punctSet.add(".");
        this.punctSet.add(",");
        this.punctSet.add("``");
        this.punctSet.add("''");
    }

    @Override
    public Set<String> getPunctuationTags() {
        return this.punctSet;
    }

    @Override
    public Parse getHead(Parse[] constituents, String type) {
        if ("TK".equals(constituents[0].getType())) {
            return null;
        }
        if (type.equals("NP") || type.equals("NX")) {
            int ci;
            String[] tags1 = new String[]{"NN", "NNP", "NNPS", "NNS", "NX", "JJR", "POS"};
            for (ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags1.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().equals(tags1[ti])) continue;
                    return constituents[ci].getHead();
                }
            }
            for (ci = 0; ci < constituents.length; ++ci) {
                if (!constituents[ci].getType().equals("NP")) continue;
                return constituents[ci].getHead();
            }
            String[] tags2 = new String[]{"$", "ADJP", "PRN"};
            for (int ci2 = constituents.length - 1; ci2 >= 0; --ci2) {
                for (int ti = tags2.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci2].getType().equals(tags2[ti])) continue;
                    return constituents[ci2].getHead();
                }
            }
            String[] tags3 = new String[]{"JJ", "JJS", "RB", "QP"};
            for (int ci3 = constituents.length - 1; ci3 >= 0; --ci3) {
                for (int ti = tags3.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci3].getType().equals(tags3[ti])) continue;
                    return constituents[ci3].getHead();
                }
            }
            return constituents[constituents.length - 1].getHead();
        }
        HeadRule hr = this.headRules.get(type);
        if (hr != null) {
            String[] tags = hr.tags;
            int cl = constituents.length;
            int tl = tags.length;
            if (hr.leftToRight) {
                for (int ti = 0; ti < tl; ++ti) {
                    for (int ci = 0; ci < cl; ++ci) {
                        if (!constituents[ci].getType().equals(tags[ti])) continue;
                        return constituents[ci].getHead();
                    }
                }
                return constituents[0].getHead();
            }
            for (int ti = 0; ti < tl; ++ti) {
                for (int ci = cl - 1; ci >= 0; --ci) {
                    if (!constituents[ci].getType().equals(tags[ti])) continue;
                    return constituents[ci].getHead();
                }
            }
            return constituents[cl - 1].getHead();
        }
        return constituents[constituents.length - 1].getHead();
    }

    private void readHeadRules(BufferedReader str) throws IOException {
        String line;
        this.headRules = new HashMap<String, HeadRule>(30);
        while ((line = str.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            String num = st.nextToken();
            String type = st.nextToken();
            String dir = st.nextToken();
            String[] tags = new String[Integer.parseInt(num) - 2];
            int ti = 0;
            while (st.hasMoreTokens()) {
                tags[ti] = st.nextToken();
                ++ti;
            }
            this.headRules.put(type, new HeadRule(dir.equals("1"), tags));
        }
    }

    @Override
    public void labelGaps(Stack<Constituent> stack) {
        if (stack.size() > 4) {
            Constituent con1 = (Constituent)stack.get(stack.size() - 2);
            Constituent con2 = (Constituent)stack.get(stack.size() - 3);
            Constituent con3 = (Constituent)stack.get(stack.size() - 4);
            Constituent con4 = (Constituent)stack.get(stack.size() - 5);
            if (con1.getLabel().equals("NP") && con2.getLabel().equals("S") && con3.getLabel().equals("SBAR")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
            } else if (con1.getLabel().equals("NP") && con2.getLabel().equals("VP") && con3.getLabel().equals("S") && con4.getLabel().equals("SBAR")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
                con4.setLabel(con4.getLabel() + "-G");
            }
        }
    }

    public void serialize(Writer writer) throws IOException {
        for (String type : this.headRules.keySet()) {
            HeadRule headRule = this.headRules.get(type);
            writer.write(Integer.toString(headRule.tags.length + 2));
            writer.write(32);
            writer.write(type);
            writer.write(32);
            if (headRule.leftToRight) {
                writer.write("1");
            } else {
                writer.write("0");
            }
            for (String tag : headRule.tags) {
                writer.write(32);
                writer.write(tag);
            }
            writer.write(10);
        }
        writer.flush();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HeadRules) {
            HeadRules rules = (HeadRules)obj;
            return rules.headRules.equals(this.headRules) && rules.punctSet.equals(this.punctSet);
        }
        return false;
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return HeadRulesSerializer.class;
    }

    private static class HeadRule {
        public boolean leftToRight;
        public String[] tags;

        public HeadRule(boolean l2r, String[] tags) {
            this.leftToRight = l2r;
            for (String tag : tags) {
                if (tag != null) continue;
                throw new IllegalArgumentException("tags must not contain null values!");
            }
            this.tags = tags;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof HeadRule) {
                HeadRule rule = (HeadRule)obj;
                return rule.leftToRight == this.leftToRight && Arrays.equals(rule.tags, this.tags);
            }
            return false;
        }
    }

    public static class HeadRulesSerializer
    implements ArtifactSerializer<HeadRules> {
        @Override
        public HeadRules create(InputStream in) throws IOException {
            return new HeadRules(new BufferedReader(new InputStreamReader(in, "UTF-8")));
        }

        @Override
        public void serialize(HeadRules artifact, OutputStream out) throws IOException {
            artifact.serialize(new OutputStreamWriter(out, "UTF-8"));
        }
    }
}

